/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SingleDistinctOptimizer
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return PlanRewriter.rewriteWith(new Optimizer(idAllocator), plan, Optional.empty());
    }

    private static class Optimizer
    extends PlanRewriter<Optional<Symbol>> {
        private final PlanNodeIdAllocator idAllocator;

        private Optimizer(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, PlanRewriter.RewriteContext<Optional<Symbol>> context) {
            ImmutableSet masks = ImmutableSet.copyOf(node.getMasks().values());
            if (masks.size() != 1 || node.getMasks().size() != node.getAggregations().size()) {
                return context.defaultRewrite(node, Optional.empty());
            }
            PlanNode source = context.rewrite(node.getSource(), Optional.of(Iterables.getOnlyElement((Iterable)masks)));
            ImmutableMap aggregations = ImmutableMap.copyOf((Map)Maps.transformValues(node.getAggregations(), call -> new FunctionCall(call.getName(), call.getWindow(), false, call.getArguments())));
            return new AggregationNode(this.idAllocator.getNextId(), source, node.getGroupBy(), (Map<Symbol, FunctionCall>)aggregations, node.getFunctions(), Collections.emptyMap(), node.getStep(), node.getSampleWeight(), node.getConfidence(), node.getHashSymbol());
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, PlanRewriter.RewriteContext<Optional<Symbol>> context) {
            Optional<Symbol> mask = context.get();
            if (mask.isPresent() && mask.get().equals(node.getMarkerSymbol())) {
                AggregationNode aggregationNode = new AggregationNode(this.idAllocator.getNextId(), context.rewrite(node.getSource(), Optional.empty()), node.getDistinctSymbols(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), AggregationNode.Step.SINGLE, Optional.empty(), 1.0, node.getHashSymbol());
                ImmutableMap.Builder outputSymbols = ImmutableMap.builder();
                for (Symbol symbol : aggregationNode.getOutputSymbols()) {
                    QualifiedNameReference expression = new QualifiedNameReference(symbol.toQualifiedName());
                    outputSymbols.put((Object)symbol, (Object)expression);
                }
                outputSymbols.put((Object)mask.get(), (Object)new NullLiteral());
                return new ProjectNode(this.idAllocator.getNextId(), aggregationNode, (Map<Symbol, Expression>)outputSymbols.build());
            }
            return context.defaultRewrite(node, Optional.empty());
        }
    }
}

