/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MetadataDeleteOptimizer
extends PlanOptimizer {
    private final Metadata metadata;

    public MetadataDeleteOptimizer(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return PlanRewriter.rewriteWith(new Optimizer(session, this.metadata, idAllocator), plan, null);
    }

    private static class Optimizer
    extends PlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final Metadata metadata;

        private Optimizer(Session session, Metadata metadata, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.metadata = metadata;
            this.idAllocator = idAllocator;
        }

        @Override
        public PlanNode visitTableCommit(TableCommitNode node, PlanRewriter.RewriteContext<Void> context) {
            Optional<DeleteNode> delete = this.findNode(node.getSource(), DeleteNode.class);
            if (!delete.isPresent()) {
                return context.defaultRewrite(node);
            }
            Optional<TableScanNode> tableScan = this.findNode(delete.get().getSource(), TableScanNode.class);
            if (!tableScan.isPresent()) {
                return context.defaultRewrite(node);
            }
            TableScanNode tableScanNode = tableScan.get();
            if (!this.metadata.supportsMetadataDelete(this.session, tableScanNode.getTable(), tableScanNode.getLayout().get())) {
                return context.defaultRewrite(node);
            }
            return new MetadataDeleteNode(this.idAllocator.getNextId(), delete.get().getTarget(), (Symbol)Iterables.getOnlyElement(node.getOutputSymbols()), tableScanNode.getLayout().get());
        }

        private <T> Optional<T> findNode(PlanNode source, Class<T> clazz) {
            while (source instanceof ExchangeNode) {
                List<PlanNode> sources = source.getSources();
                if (sources.size() != 1) {
                    return Optional.empty();
                }
                source = sources.get(0);
            }
            if (clazz.isInstance(source)) {
                return Optional.of(clazz.cast(source));
            }
            return Optional.empty();
        }
    }
}

