/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Approximate;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class QueryPlanner
extends DefaultTraversalVisitor<PlanBuilder, Void> {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;

    QueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
    }

    protected PlanBuilder visitQuery(Query query, Void context) {
        PlanBuilder builder = this.planQueryBody(query);
        Set<InPredicate> inPredicates = this.analysis.getInPredicates((Node)query);
        builder = this.appendSemiJoins(builder, inPredicates);
        List<FieldOrExpression> orderBy = this.analysis.getOrderByExpressions((Node)query);
        List<FieldOrExpression> outputs = this.analysis.getOutputExpressions((Node)query);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.sort(builder, query);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)query));
        builder = this.limit(builder, query);
        return builder;
    }

    protected PlanBuilder visitQuerySpecification(QuerySpecification node, Void context) {
        PlanBuilder builder = this.planFrom(node);
        Set<InPredicate> inPredicates = this.analysis.getInPredicates((Node)node);
        builder = this.appendSemiJoins(builder, inPredicates);
        builder = this.filter(builder, this.analysis.getWhere(node));
        builder = this.aggregate(builder, node);
        builder = this.filter(builder, this.analysis.getHaving(node));
        builder = this.window(builder, node);
        List<FieldOrExpression> orderBy = this.analysis.getOrderByExpressions((Node)node);
        List<FieldOrExpression> outputs = this.analysis.getOutputExpressions((Node)node);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.distinct(builder, node, outputs, orderBy);
        builder = this.sort(builder, node);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)node));
        builder = this.limit(builder, node);
        return builder;
    }

    private PlanBuilder planQueryBody(Query query) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)query.getQueryBody(), null);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight());
    }

    private PlanBuilder planFrom(QuerySpecification node) {
        RelationPlan relationPlan = node.getFrom().isPresent() ? (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node.getFrom().get(), null) : this.planImplicitTable();
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight());
    }

    public DeleteNode planDelete(Delete node) {
        TupleDescriptor descriptor = this.analysis.getOutputDescriptor((Node)node.getTable());
        TableHandle handle = this.analysis.getTableHandle(node.getTable());
        ColumnHandle rowIdHandle = this.metadata.getUpdateRowIdColumnHandle(this.session, handle);
        Type rowIdType = this.metadata.getColumnMetadata(this.session, handle, rowIdHandle).getType();
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Field field : descriptor.getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field.getName().get(), field.getType());
            outputSymbols.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
            fields.add((Object)field);
        }
        Field rowIdField = Field.newUnqualified(Optional.empty(), rowIdType);
        Symbol rowIdSymbol = this.symbolAllocator.newSymbol("$rowId", rowIdField.getType());
        outputSymbols.add((Object)rowIdSymbol);
        columns.put((Object)rowIdSymbol, (Object)rowIdHandle);
        fields.add((Object)rowIdField);
        TableScanNode tableScan = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols.build(), (Map<Symbol, ColumnHandle>)columns.build(), Optional.empty(), (TupleDomain<ColumnHandle>)TupleDomain.all(), null);
        RelationPlan relationPlan = new RelationPlan(tableScan, new TupleDescriptor((List<Field>)fields.build()), (List<Symbol>)outputSymbols.build(), Optional.empty());
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        PlanBuilder builder = new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight());
        Set<InPredicate> inPredicates = this.analysis.getInPredicates((Node)node);
        builder = this.appendSemiJoins(builder, inPredicates);
        if (node.getWhere().isPresent()) {
            builder = this.filter(builder, (Expression)node.getWhere().get());
        }
        Symbol rowId = builder.translate(new FieldOrExpression(relationPlan.getDescriptor().indexOf(rowIdField)));
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        return new DeleteNode(this.idAllocator.getNextId(), builder.getRoot(), new TableWriterNode.DeleteHandle(handle), rowId, (List<Symbol>)outputs);
    }

    private RelationPlan planImplicitTable() {
        ImmutableList emptyRow = ImmutableList.of();
        return new RelationPlan(new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)emptyRow)), new TupleDescriptor(new Field[0]), (List<Symbol>)ImmutableList.of(), Optional.empty());
    }

    private PlanBuilder filter(PlanBuilder subPlan, Expression predicate) {
        if (predicate == null) {
            return subPlan;
        }
        Expression rewritten = subPlan.rewrite(predicate);
        return new PlanBuilder(subPlan.getTranslations(), new FilterNode(this.idAllocator.getNextId(), subPlan.getRoot(), rewritten), subPlan.getSampleWeight());
    }

    private PlanBuilder project(PlanBuilder subPlan, Iterable<FieldOrExpression> expressions) {
        TranslationMap outputTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (FieldOrExpression fieldOrExpression : ImmutableSet.copyOf(expressions)) {
            Symbol symbol;
            if (fieldOrExpression.isFieldReference()) {
                Field field = subPlan.getRelationPlan().getDescriptor().getFieldByIndex(fieldOrExpression.getFieldIndex());
                symbol = this.symbolAllocator.newSymbol(field);
            } else {
                Expression expression = fieldOrExpression.getExpression();
                symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            }
            projections.put((Object)symbol, (Object)subPlan.rewrite(fieldOrExpression));
            outputTranslations.put(fieldOrExpression, symbol);
        }
        if (subPlan.getSampleWeight().isPresent()) {
            Symbol symbol = subPlan.getSampleWeight().get();
            projections.put((Object)symbol, (Object)new QualifiedNameReference(symbol.toQualifiedName()));
        }
        return new PlanBuilder(outputTranslations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private Map<Symbol, Expression> coerce(Iterable<? extends Expression> expressions, PlanBuilder subPlan, TranslationMap translations) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Type coercion = this.analysis.getCoercion(expression);
            Symbol symbol = this.symbolAllocator.newSymbol(expression, (Type)MoreObjects.firstNonNull((Object)coercion, (Object)this.analysis.getType(expression)));
            Expression rewritten = subPlan.rewrite(expression);
            if (coercion != null) {
                rewritten = new Cast(rewritten, coercion.getTypeSignature().toString());
            }
            projections.put((Object)symbol, (Object)rewritten);
            translations.put(expression, symbol);
        }
        return projections.build();
    }

    private PlanBuilder explicitCoercionFields(PlanBuilder subPlan, Iterable<FieldOrExpression> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        ImmutableMap.Builder projections = ImmutableMap.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (FieldOrExpression fieldOrExpression : alreadyCoerced) {
            Symbol symbol;
            if (fieldOrExpression.isFieldReference()) {
                Field field = subPlan.getRelationPlan().getDescriptor().getFieldByIndex(fieldOrExpression.getFieldIndex());
                symbol = this.symbolAllocator.newSymbol(field);
            } else {
                symbol = this.symbolAllocator.newSymbol(fieldOrExpression.getExpression(), this.analysis.getType(fieldOrExpression.getExpression()));
            }
            Expression rewritten = subPlan.rewrite(fieldOrExpression);
            projections.put((Object)symbol, (Object)rewritten);
            translations.put(fieldOrExpression, symbol);
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private PlanBuilder explicitCoercionSymbols(PlanBuilder subPlan, Iterable<Symbol> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        ImmutableMap.Builder projections = ImmutableMap.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (Symbol symbol : alreadyCoerced) {
            projections.put((Object)symbol, (Object)new QualifiedNameReference(symbol.toQualifiedName()));
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private PlanBuilder aggregate(PlanBuilder subPlan, QuerySpecification node) {
        if (this.analysis.getAggregates(node).isEmpty() && this.analysis.getGroupByExpressions(node).isEmpty()) {
            return subPlan;
        }
        Set arguments = (Set)this.analysis.getAggregates(node).stream().map(FunctionCall::getArguments).flatMap(Collection::stream).map(FieldOrExpression::new).collect(ImmutableCollectors.toImmutableSet());
        Iterable inputs = Iterables.concat(this.analysis.getGroupByExpressions(node), (Iterable)arguments);
        if (!Iterables.isEmpty((Iterable)inputs)) {
            subPlan = this.project(subPlan, inputs);
        }
        ImmutableMap.Builder aggregationAssignments = ImmutableMap.builder();
        ImmutableMap.Builder functions = ImmutableMap.builder();
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        boolean needPostProjectionCoercion = false;
        for (FunctionCall functionCall : this.analysis.getAggregates(node)) {
            Expression rewritten = subPlan.rewrite((Expression)functionCall);
            Symbol newSymbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getType((Expression)functionCall));
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
                needPostProjectionCoercion = true;
            }
            aggregationAssignments.put((Object)newSymbol, (Object)((FunctionCall)rewritten));
            translations.put((Expression)functionCall, newSymbol);
            functions.put((Object)newSymbol, (Object)this.analysis.getFunctionSignature(functionCall));
        }
        LinkedHashSet<Symbol> groupBySymbols = new LinkedHashSet<Symbol>();
        for (FieldOrExpression fieldOrExpression : this.analysis.getGroupByExpressions(node)) {
            Iterator symbol = subPlan.translate(fieldOrExpression);
            groupBySymbols.add((Symbol)((Object)symbol));
            translations.put(fieldOrExpression, (Symbol)((Object)symbol));
        }
        HashMap<ImmutableSet, Object> hashMap = new HashMap<ImmutableSet, Object>();
        HashMap<Symbol, Symbol> masks = new HashMap<Symbol, Symbol>();
        for (FunctionCall aggregate : Iterables.filter(this.analysis.getAggregates(node), FunctionCall::isDistinct)) {
            ImmutableSet args = ImmutableSet.copyOf((Collection)aggregate.getArguments());
            Object marker = (Symbol)hashMap.get(args);
            Symbol aggregateSymbol = translations.get((Expression)aggregate);
            if (marker == null) {
                marker = args.size() == 1 ? this.symbolAllocator.newSymbol((Expression)Iterables.getOnlyElement((Iterable)args), (Type)BooleanType.BOOLEAN, "distinct") : this.symbolAllocator.newSymbol(aggregateSymbol.getName(), (Type)BooleanType.BOOLEAN, "distinct");
                hashMap.put(args, marker);
            }
            masks.put(aggregateSymbol, (Symbol)marker);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(groupBySymbols);
            for (Expression expression : (Set)entry.getKey()) {
                builder.add((Object)subPlan.translate(expression));
            }
            MarkDistinctNode markDistinct = new MarkDistinctNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Symbol)entry.getValue(), (List<Symbol>)builder.build(), Optional.empty());
            subPlan = new PlanBuilder(subPlan.getTranslations(), markDistinct, subPlan.getSampleWeight());
        }
        double confidence = 1.0;
        if (this.analysis.getQuery().getApproximate().isPresent()) {
            confidence = Double.valueOf(((Approximate)this.analysis.getQuery().getApproximate().get()).getConfidence()) / 100.0;
        }
        AggregationNode aggregationNode = new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)ImmutableList.copyOf(groupBySymbols), (Map<Symbol, FunctionCall>)aggregationAssignments.build(), (Map<Symbol, Signature>)functions.build(), masks, AggregationNode.Step.SINGLE, subPlan.getSampleWeight(), confidence, Optional.empty());
        subPlan = new PlanBuilder(translations, aggregationNode, Optional.empty());
        if (needPostProjectionCoercion) {
            return this.explicitCoercionFields(subPlan, this.analysis.getGroupByExpressions(node), this.analysis.getAggregates(node));
        }
        return subPlan;
    }

    private PlanBuilder window(PlanBuilder subPlan, QuerySpecification node) {
        ImmutableSet windowFunctions = ImmutableSet.copyOf(this.analysis.getWindowFunctions(node));
        if (windowFunctions.isEmpty()) {
            return subPlan;
        }
        for (FunctionCall windowFunction : windowFunctions) {
            Window window = (Window)windowFunction.getWindow().get();
            WindowFrame.Type frameType = WindowFrame.Type.RANGE;
            FrameBound.Type frameStartType = FrameBound.Type.UNBOUNDED_PRECEDING;
            FrameBound.Type frameEndType = FrameBound.Type.CURRENT_ROW;
            Expression frameStart = null;
            Expression frameEnd = null;
            if (window.getFrame().isPresent()) {
                WindowFrame frame = (WindowFrame)window.getFrame().get();
                frameType = frame.getType();
                frameStartType = frame.getStart().getType();
                frameStart = frame.getStart().getValue().orElse(null);
                if (frame.getEnd().isPresent()) {
                    frameEndType = ((FrameBound)frame.getEnd().get()).getType();
                    frameEnd = ((FrameBound)frame.getEnd().get()).getValue().orElse(null);
                }
            }
            ImmutableList.Builder inputs = ImmutableList.builder().addAll((Iterable)windowFunction.getArguments()).addAll((Iterable)window.getPartitionBy()).addAll(Iterables.transform((Iterable)window.getOrderBy(), SortItem::getSortKey));
            if (frameStart != null) {
                inputs.add(frameStart);
            }
            if (frameEnd != null) {
                inputs.add(frameEnd);
            }
            subPlan = this.appendProjections(subPlan, (Iterable<Expression>)inputs.build());
            ImmutableList.Builder partitionBySymbols = ImmutableList.builder();
            for (Expression expression : window.getPartitionBy()) {
                partitionBySymbols.add((Object)subPlan.translate(expression));
            }
            ImmutableList.Builder orderBySymbols = ImmutableList.builder();
            HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
            for (SortItem item : window.getOrderBy()) {
                Symbol symbol = subPlan.translate(item.getSortKey());
                orderBySymbols.add((Object)symbol);
                orderings.put(symbol, this.toSortOrder(item));
            }
            Optional<Symbol> frameStartSymbol = Optional.empty();
            Optional<Symbol> frameEndSymbol = Optional.empty();
            if (frameStart != null) {
                frameStartSymbol = Optional.of(subPlan.translate(frameStart));
            }
            if (frameEnd != null) {
                frameEndSymbol = Optional.of(subPlan.translate(frameEnd));
            }
            WindowNode.Frame frame = new WindowNode.Frame(frameType, frameStartType, frameStartSymbol, frameEndType, frameEndSymbol);
            TranslationMap outputTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
            outputTranslations.copyMappingsFrom(subPlan.getTranslations());
            ImmutableMap.Builder assignments = ImmutableMap.builder();
            HashMap<Symbol, Signature> signatures = new HashMap<Symbol, Signature>();
            Expression rewritten = subPlan.rewrite((Expression)windowFunction);
            Symbol newSymbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getType((Expression)windowFunction));
            boolean needCoercion = rewritten instanceof Cast;
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
            }
            assignments.put((Object)newSymbol, (Object)((FunctionCall)rewritten));
            outputTranslations.put((Expression)windowFunction, newSymbol);
            signatures.put(newSymbol, this.analysis.getFunctionSignature(windowFunction));
            List<Symbol> sourceSymbols = subPlan.getRoot().getOutputSymbols();
            subPlan = new PlanBuilder(outputTranslations, new WindowNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)partitionBySymbols.build(), (List<Symbol>)orderBySymbols.build(), orderings, frame, (Map<Symbol, FunctionCall>)assignments.build(), signatures, Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0), subPlan.getSampleWeight());
            if (!needCoercion) continue;
            subPlan = this.explicitCoercionSymbols(subPlan, sourceSymbols, (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
        }
        return subPlan;
    }

    private PlanBuilder appendProjections(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Symbol symbol : subPlan.getRoot().getOutputSymbols()) {
            QualifiedNameReference qualifiedNameReference = new QualifiedNameReference(symbol.toQualifiedName());
            projections.put((Object)symbol, (Object)qualifiedNameReference);
        }
        ImmutableMap.Builder newTranslations = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            projections.put((Object)symbol, (Object)translations.rewrite(expression));
            newTranslations.put((Object)symbol, (Object)expression);
        }
        for (Map.Entry entry : newTranslations.build().entrySet()) {
            translations.put((Expression)entry.getValue(), (Symbol)entry.getKey());
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private PlanBuilder appendSemiJoins(PlanBuilder subPlan, Set<InPredicate> inPredicates) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendSemiJoin(subPlan, inPredicate);
        }
        return subPlan;
    }

    private PlanBuilder appendSemiJoin(PlanBuilder subPlan, InPredicate inPredicate) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        translations.copyMappingsFrom(subPlan.getTranslations());
        subPlan = this.appendProjections(subPlan, (Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()));
        Symbol sourceJoinSymbol = subPlan.translate(inPredicate.getValue());
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression subqueryExpression = (SubqueryExpression)inPredicate.getValueList();
        RelationPlanner relationPlanner = new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
        RelationPlan valueListRelation = (RelationPlan)relationPlanner.process((Node)subqueryExpression.getQuery(), null);
        Symbol filteringSourceJoinSymbol = (Symbol)Iterables.getOnlyElement(valueListRelation.getRoot().getOutputSymbols());
        Symbol semiJoinOutputSymbol = this.symbolAllocator.newSymbol("semijoinresult", (Type)BooleanType.BOOLEAN);
        translations.put((Expression)inPredicate, semiJoinOutputSymbol);
        return new PlanBuilder(translations, new SemiJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), valueListRelation.getRoot(), sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutputSymbol, Optional.empty(), Optional.empty()), subPlan.getSampleWeight());
    }

    private PlanBuilder distinct(PlanBuilder subPlan, QuerySpecification node, List<FieldOrExpression> outputs, List<FieldOrExpression> orderBy) {
        if (node.getSelect().isDistinct()) {
            Preconditions.checkState((boolean)outputs.containsAll(orderBy), (Object)"Expected ORDER BY terms to be in SELECT. Broken analysis");
            AggregationNode aggregation = new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), subPlan.getRoot().getOutputSymbols(), (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, Signature>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), AggregationNode.Step.SINGLE, Optional.empty(), 1.0, Optional.empty());
            return new PlanBuilder(subPlan.getTranslations(), aggregation, subPlan.getSampleWeight());
        }
        return subPlan;
    }

    private PlanBuilder sort(PlanBuilder subPlan, Query node) {
        return this.sort(subPlan, node.getOrderBy(), node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, QuerySpecification node) {
        return this.sort(subPlan, node.getOrderBy(), node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, List<SortItem> orderBy, Optional<String> limit, List<FieldOrExpression> orderByExpressions) {
        if (orderBy.isEmpty()) {
            return subPlan;
        }
        Iterator<SortItem> sortItems = orderBy.iterator();
        ImmutableList.Builder orderBySymbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
        for (FieldOrExpression fieldOrExpression : orderByExpressions) {
            Symbol symbol = subPlan.translate(fieldOrExpression);
            SortItem sortItem = sortItems.next();
            if (orderings.containsKey(symbol)) continue;
            orderBySymbols.add((Object)symbol);
            orderings.put(symbol, this.toSortOrder(sortItem));
        }
        PlanNode planNode = limit.isPresent() && !limit.get().equalsIgnoreCase("all") ? new TopNNode(this.idAllocator.getNextId(), subPlan.getRoot(), Long.parseLong(limit.get()), (List<Symbol>)orderBySymbols.build(), orderings, false) : new SortNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)orderBySymbols.build(), orderings);
        return new PlanBuilder(subPlan.getTranslations(), planNode, subPlan.getSampleWeight());
    }

    private PlanBuilder limit(PlanBuilder subPlan, Query node) {
        return this.limit(subPlan, node.getOrderBy(), node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, QuerySpecification node) {
        return this.limit(subPlan, node.getOrderBy(), node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, List<SortItem> orderBy, Optional<String> limit) {
        if (orderBy.isEmpty() && limit.isPresent()) {
            if (limit.get().equalsIgnoreCase("all")) {
                return subPlan;
            }
            long limitValue = Long.parseLong(limit.get());
            return new PlanBuilder(subPlan.getTranslations(), new LimitNode(this.idAllocator.getNextId(), subPlan.getRoot(), limitValue), subPlan.getSampleWeight());
        }
        return subPlan;
    }

    private SortOrder toSortOrder(SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }
}

