/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class LookupSymbolResolver
implements SymbolResolver {
    private final Map<Symbol, ColumnHandle> assignments;
    private final Map<ColumnHandle, ?> bindings;

    public LookupSymbolResolver(Map<Symbol, ColumnHandle> assignments, Map<ColumnHandle, ?> bindings) {
        Objects.requireNonNull(assignments, "assignments is null");
        Objects.requireNonNull(bindings, "bindings is null");
        this.assignments = ImmutableMap.copyOf(assignments);
        this.bindings = ImmutableMap.copyOf(bindings);
    }

    @Override
    public Object getValue(Symbol symbol) {
        ColumnHandle column = this.assignments.get(symbol);
        Preconditions.checkArgument((column != null ? 1 : 0) != 0, (String)"Missing column assignment for %s", (Object[])new Object[]{symbol});
        if (!this.bindings.containsKey(column)) {
            return new QualifiedNameReference(symbol.toQualifiedName());
        }
        Object value = this.bindings.get(column);
        if (value instanceof String) {
            return Slices.wrappedBuffer((byte[])((String)value).getBytes(StandardCharsets.UTF_8));
        }
        return value;
    }
}

