/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public final class DependencyExtractor {
    private DependencyExtractor() {
    }

    public static Set<Symbol> extractUnique(Expression expression) {
        return ImmutableSet.copyOf(DependencyExtractor.extractAll(expression));
    }

    public static Set<Symbol> extractUnique(Iterable<? extends Expression> expressions) {
        ImmutableSet.Builder unique = ImmutableSet.builder();
        for (Expression expression : expressions) {
            unique.addAll(DependencyExtractor.extractAll(expression));
        }
        return unique.build();
    }

    public static List<Symbol> extractAll(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new SymbolBuilderVisitor().process((Node)expression, builder);
        return builder.build();
    }

    public static Set<QualifiedName> extractNames(Expression expression) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new QualifiedNameBuilderVisitor().process((Node)expression, builder);
        return builder.build();
    }

    private static class QualifiedNameBuilderVisitor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableSet.Builder<QualifiedName>> {
        private QualifiedNameBuilderVisitor() {
        }

        protected Void visitQualifiedNameReference(QualifiedNameReference node, ImmutableSet.Builder<QualifiedName> builder) {
            builder.add((Object)node.getName());
            return null;
        }
    }

    private static class SymbolBuilderVisitor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableList.Builder<Symbol>> {
        private SymbolBuilderVisitor() {
        }

        protected Void visitQualifiedNameReference(QualifiedNameReference node, ImmutableList.Builder<Symbol> builder) {
            builder.add((Object)Symbol.fromQualifiedName(node.getName()));
            return null;
        }
    }
}

