/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.control.LookupSwitch;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.util.FastutilSetHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class InCodeGenerator
implements ByteCodeGenerator {
    private final FunctionRegistry registry;

    public InCodeGenerator(FunctionRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
    }

    @VisibleForTesting
    static SwitchGenerationCase checkSwitchGenerationCase(Type type, List<RowExpression> values) {
        if (values.size() <= 1000) {
            if (!(type instanceof BigintType) && !(type instanceof DateType)) {
                return SwitchGenerationCase.HASH_SWITCH;
            }
            boolean areSmallPrimitives = true;
            for (RowExpression expression : values) {
                long longConstant;
                Object constant;
                if (!(expression instanceof ConstantExpression) || (constant = ((ConstantExpression)expression).getValue()) == null || (longConstant = ((Long)constant).longValue()) >= Integer.MIN_VALUE && longConstant <= Integer.MAX_VALUE) continue;
                areSmallPrimitives = false;
                break;
            }
            return areSmallPrimitives ? SwitchGenerationCase.DIRECT_SWITCH : SwitchGenerationCase.HASH_SWITCH;
        }
        return SwitchGenerationCase.SET_CONTAINS;
    }

    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        ByteCodeBlock switchBlock;
        ByteCodeNode value = generatorContext.generate(arguments.get(0));
        List<RowExpression> values = arguments.subList(1, arguments.size());
        ImmutableList.Builder valuesByteCode = ImmutableList.builder();
        for (int i = 1; i < arguments.size(); ++i) {
            ByteCodeNode testNode = generatorContext.generate(arguments.get(i));
            valuesByteCode.add((Object)testNode);
        }
        Type type = arguments.get(0).getType();
        Class<Object> javaType = type.getJavaType();
        SwitchGenerationCase switchGenerationCase = InCodeGenerator.checkSwitchGenerationCase(type, values);
        Signature hashCodeSignature = Signature.internalOperator(OperatorType.HASH_CODE, (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)type));
        MethodHandle hashCodeFunction = generatorContext.getRegistry().getScalarFunctionImplementation(hashCodeSignature).getMethodHandle();
        ImmutableListMultimap.Builder hashBucketsBuilder = ImmutableListMultimap.builder();
        ImmutableList.Builder defaultBucket = ImmutableList.builder();
        ImmutableSet.Builder constantValuesBuilder = ImmutableSet.builder();
        for (RowExpression testValue : values) {
            ByteCodeNode testByteCode = generatorContext.generate(testValue);
            if (testValue instanceof ConstantExpression && ((ConstantExpression)testValue).getValue() != null) {
                ConstantExpression constant = (ConstantExpression)testValue;
                Object object = constant.getValue();
                switch (switchGenerationCase) {
                    case DIRECT_SWITCH: 
                    case SET_CONTAINS: {
                        constantValuesBuilder.add(object);
                        break;
                    }
                    case HASH_SWITCH: {
                        try {
                            int hashCode = Ints.checkedCast((long)hashCodeFunction.invoke(object));
                            hashBucketsBuilder.put((Object)hashCode, (Object)testByteCode);
                            break;
                        }
                        catch (Throwable throwable) {
                            throw new IllegalArgumentException("Error processing IN statement: error calculating hash code for " + object, throwable);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Not supported switch generation case: " + (Object)((Object)switchGenerationCase));
                    }
                }
                continue;
            }
            defaultBucket.add((Object)testByteCode);
        }
        ImmutableListMultimap hashBuckets = hashBucketsBuilder.build();
        ImmutableSet constantValues = constantValuesBuilder.build();
        LabelNode end = new LabelNode("end");
        LabelNode match = new LabelNode("match");
        LabelNode noMatch = new LabelNode("noMatch");
        LabelNode defaultLabel = new LabelNode("default");
        Scope scope = generatorContext.getScope();
        ByteCodeBlock switchCaseBlocks = new ByteCodeBlock();
        LookupSwitch.LookupSwitchBuilder switchBuilder = LookupSwitch.lookupSwitchBuilder();
        switch (switchGenerationCase) {
            case DIRECT_SWITCH: {
                for (Object constantValue : constantValues) {
                    switchBuilder.addCase(Ints.checkedCast((long)((Long)constantValue)), match);
                }
                switchBuilder.defaultCase(defaultLabel);
                switchBlock = new ByteCodeBlock().comment("lookupSwitch(<stackValue>))").dup(javaType).longToInt().append(switchBuilder.build());
                break;
            }
            case HASH_SWITCH: {
                for (Map.Entry bucket : hashBuckets.asMap().entrySet()) {
                    LabelNode label = new LabelNode("inHash" + bucket.getKey());
                    switchBuilder.addCase((Integer)bucket.getKey(), label);
                    Collection testValues = (Collection)bucket.getValue();
                    ByteCodeBlock caseBlock = this.buildInCase(generatorContext, scope, type, label, match, defaultLabel, testValues, false);
                    switchCaseBlocks.append(caseBlock.setDescription("case " + bucket.getKey()));
                }
                switchBuilder.defaultCase(defaultLabel);
                Binding hashCodeBinding = generatorContext.getCallSiteBinder().bind(hashCodeFunction);
                switchBlock = new ByteCodeBlock().comment("lookupSwitch(hashCode(<stackValue>))").dup(javaType).append(ByteCodeUtils.invoke(hashCodeBinding, hashCodeSignature)).longToInt().append(switchBuilder.build()).append(switchCaseBlocks);
                break;
            }
            case SET_CONTAINS: {
                Set<?> constantValuesSet = FastutilSetHelper.toFastutilHashSet(constantValues, type, this.registry);
                Binding constant = generatorContext.getCallSiteBinder().bind(constantValuesSet, constantValuesSet.getClass());
                switchBlock = new ByteCodeBlock().comment("inListSet.contains(<stackValue>)").append(new IfStatement().condition(new ByteCodeBlock().comment("value").dup(javaType).comment("set").append(ByteCodeUtils.loadConstant(constant)).invokeStatic(FastutilSetHelper.class, "in", Boolean.TYPE, javaType.isPrimitive() ? javaType : Object.class, constantValuesSet.getClass())).ifTrue(JumpInstruction.jump(match)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported switch generation case: " + (Object)((Object)switchGenerationCase));
            }
        }
        ByteCodeBlock defaultCaseBlock = this.buildInCase(generatorContext, scope, type, defaultLabel, match, noMatch, (Collection<ByteCodeNode>)defaultBucket.build(), true).setDescription("default");
        ByteCodeBlock block = new ByteCodeBlock().comment("IN").append(value).append(ByteCodeUtils.ifWasNullPopAndGoto(scope, end, Boolean.TYPE, javaType)).append(switchBlock).append(defaultCaseBlock);
        ByteCodeBlock matchBlock = new ByteCodeBlock().setDescription("match").visitLabel(match).pop(javaType).append(generatorContext.wasNull().set(ByteCodeExpressions.constantFalse())).push(true).gotoLabel(end);
        block.append(matchBlock);
        ByteCodeBlock noMatchBlock = new ByteCodeBlock().setDescription("noMatch").visitLabel(noMatch).pop(javaType).push(false).gotoLabel(end);
        block.append(noMatchBlock);
        block.visitLabel(end);
        return block;
    }

    private ByteCodeBlock buildInCase(ByteCodeGeneratorContext generatorContext, Scope scope, Type type, LabelNode caseLabel, LabelNode matchLabel, LabelNode noMatchLabel, Collection<ByteCodeNode> testValues, boolean checkForNulls) {
        Variable caseWasNull = null;
        if (checkForNulls) {
            caseWasNull = scope.createTempVariable(Boolean.TYPE);
        }
        ByteCodeBlock caseBlock = new ByteCodeBlock().visitLabel(caseLabel);
        if (checkForNulls) {
            caseBlock.putVariable(caseWasNull, false);
        }
        LabelNode elseLabel = new LabelNode("else");
        ByteCodeBlock elseBlock = new ByteCodeBlock().visitLabel(elseLabel);
        Variable wasNull = generatorContext.wasNull();
        if (checkForNulls) {
            elseBlock.append(wasNull.set(caseWasNull));
        }
        elseBlock.gotoLabel(noMatchLabel);
        ScalarFunctionImplementation operator = generatorContext.getRegistry().getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type)));
        Binding equalsFunction = generatorContext.getCallSiteBinder().bind(operator.getMethodHandle());
        ByteCodeNode elseNode = elseBlock;
        for (ByteCodeNode testNode : testValues) {
            LabelNode testLabel = new LabelNode("test");
            IfStatement test = new IfStatement();
            test.condition().visitLabel(testLabel).dup(type.getJavaType()).append(testNode);
            if (checkForNulls) {
                test.condition().append(wasNull).putVariable(caseWasNull).append(ByteCodeUtils.ifWasNullPopAndGoto(scope, elseLabel, Void.TYPE, type.getJavaType(), type.getJavaType()));
            }
            test.condition().append(ByteCodeUtils.invoke(equalsFunction, OperatorType.EQUAL.name()));
            test.ifTrue().gotoLabel(matchLabel);
            test.ifFalse(elseNode);
            elseNode = test;
            elseLabel = testLabel;
        }
        caseBlock.append(elseNode);
        return caseBlock;
    }

    static enum SwitchGenerationCase {
        DIRECT_SWITCH,
        HASH_SWITCH,
        SET_CONTAINS;

    }
}

