/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.DenyAllAccessControl;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.IntervalYearMonthType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.AnalysisContext;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ArithmeticUnaryExpression;
import com.facebook.presto.sql.tree.ArrayConstructor;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BetweenPredicate;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CurrentTime;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Extract;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IfExpression;
import com.facebook.presto.sql.tree.InListExpression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.IsNotNullPredicate;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.NullIfExpression;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SearchedCaseExpression;
import com.facebook.presto.sql.tree.SimpleCaseExpression;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SubscriptExpression;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.sql.tree.WhenClause;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.type.ArrayParametricType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExpressionAnalyzer {
    private final FunctionRegistry functionRegistry;
    private final TypeManager typeManager;
    private final Function<Node, StatementAnalyzer> statementAnalyzerFactory;
    private final Map<QualifiedName, Integer> resolvedNames = new HashMap<QualifiedName, Integer>();
    private final IdentityHashMap<FunctionCall, Signature> resolvedFunctions = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> expressionTypes = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> expressionCoercions = new IdentityHashMap();
    private final IdentityHashMap<Expression, Boolean> rowFieldReferences = new IdentityHashMap();
    private final Set<InPredicate> subqueryInPredicates = Sets.newIdentityHashSet();
    private final Session session;

    public ExpressionAnalyzer(FunctionRegistry functionRegistry, TypeManager typeManager, Function<Node, StatementAnalyzer> statementAnalyzerFactory, Session session) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public Map<QualifiedName, Integer> getResolvedNames() {
        return this.resolvedNames;
    }

    public IdentityHashMap<FunctionCall, Signature> getResolvedFunctions() {
        return this.resolvedFunctions;
    }

    public IdentityHashMap<Expression, Type> getExpressionTypes() {
        return this.expressionTypes;
    }

    public IdentityHashMap<Expression, Type> getExpressionCoercions() {
        return this.expressionCoercions;
    }

    public IdentityHashMap<Expression, Boolean> getRowFieldReferences() {
        return this.rowFieldReferences;
    }

    public Set<InPredicate> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }

    public Type analyze(Expression expression, TupleDescriptor tupleDescriptor, AnalysisContext context) {
        ScalarSubqueryDetector scalarSubqueryDetector = new ScalarSubqueryDetector();
        expression.accept((AstVisitor)scalarSubqueryDetector, null);
        Visitor visitor = new Visitor(tupleDescriptor);
        return (Type)expression.accept((AstVisitor)visitor, (Object)context);
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypes(Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types, Expression expression) {
        return ExpressionAnalyzer.getExpressionTypes(session, metadata, sqlParser, types, (Iterable<? extends Expression>)ImmutableList.of((Object)expression));
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypes(Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types, Iterable<? extends Expression> expressions) {
        return ExpressionAnalyzer.analyzeExpressionsWithSymbols(session, metadata, sqlParser, types, expressions).getExpressionTypes();
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypesFromInput(Session session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Expression expression) {
        return ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, types, (Iterable<? extends Expression>)ImmutableList.of((Object)expression));
    }

    public static IdentityHashMap<Expression, Type> getExpressionTypesFromInput(Session session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Iterable<? extends Expression> expressions) {
        return ExpressionAnalyzer.analyzeExpressionsWithInputs(session, metadata, sqlParser, types, expressions).getExpressionTypes();
    }

    public static ExpressionAnalysis analyzeExpressionsWithSymbols(Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types, Iterable<? extends Expression> expressions) {
        List fields = (List)DependencyExtractor.extractUnique(expressions).stream().map(symbol -> {
            Type type = (Type)types.get(symbol);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"No type for symbol %s", (Object[])new Object[]{symbol});
            return Field.newUnqualified(symbol.getName(), type);
        }).collect(ImmutableCollectors.toImmutableList());
        return ExpressionAnalyzer.analyzeExpressions(session, metadata, sqlParser, new TupleDescriptor(fields), expressions);
    }

    private static ExpressionAnalysis analyzeExpressionsWithInputs(Session session, Metadata metadata, SqlParser sqlParser, Map<Integer, Type> types, Iterable<? extends Expression> expressions) {
        Field[] fields = new Field[types.size()];
        for (Map.Entry<Integer, Type> entry : types.entrySet()) {
            fields[entry.getKey().intValue()] = Field.newUnqualified(Optional.empty(), entry.getValue());
        }
        TupleDescriptor tupleDescriptor = new TupleDescriptor(fields);
        return ExpressionAnalyzer.analyzeExpressions(session, metadata, sqlParser, tupleDescriptor, expressions);
    }

    private static ExpressionAnalysis analyzeExpressions(Session session, Metadata metadata, SqlParser sqlParser, TupleDescriptor tupleDescriptor, Iterable<? extends Expression> expressions) {
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(new Analysis(), session, metadata, sqlParser, new DenyAllAccessControl(), false);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, tupleDescriptor, new AnalysisContext());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getExpressionCoercions(), analyzer.getSubqueryInPredicates());
    }

    public static ExpressionAnalysis analyzeExpression(Session session, Metadata metadata, AccessControl accessControl, SqlParser sqlParser, TupleDescriptor tupleDescriptor, Analysis analysis, boolean approximateQueriesEnabled, AnalysisContext context, Expression expression) {
        ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(analysis, session, metadata, sqlParser, accessControl, approximateQueriesEnabled);
        analyzer.analyze(expression, tupleDescriptor, context);
        IdentityHashMap<Expression, Type> expressionTypes = analyzer.getExpressionTypes();
        IdentityHashMap<Expression, Type> expressionCoercions = analyzer.getExpressionCoercions();
        IdentityHashMap<FunctionCall, Signature> resolvedFunctions = analyzer.getResolvedFunctions();
        analysis.addTypes(expressionTypes);
        analysis.addCoercions(expressionCoercions);
        analysis.addFunctionSignatures(resolvedFunctions);
        analysis.addRowFieldReferences(analyzer.getRowFieldReferences());
        for (Expression subExpression : expressionTypes.keySet()) {
            analysis.addResolvedNames(subExpression, analyzer.getResolvedNames());
        }
        Set<InPredicate> subqueryInPredicates = analyzer.getSubqueryInPredicates();
        return new ExpressionAnalysis(expressionTypes, expressionCoercions, subqueryInPredicates);
    }

    public static ExpressionAnalyzer create(Analysis analysis, Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, boolean experimentalSyntaxEnabled) {
        return new ExpressionAnalyzer(metadata.getFunctionRegistry(), metadata.getTypeManager(), node -> new StatementAnalyzer(analysis, metadata, sqlParser, accessControl, session, experimentalSyntaxEnabled, Optional.empty()), session);
    }

    public static ExpressionAnalyzer createConstantAnalyzer(Metadata metadata, Session session) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata.getFunctionRegistry(), metadata.getTypeManager(), session, SemanticErrorCode.EXPRESSION_NOT_CONSTANT, "Constant expression cannot contain a subquery");
    }

    public static ExpressionAnalyzer createWithoutSubqueries(FunctionRegistry functionRegistry, TypeManager typeManager, Session session, SemanticErrorCode errorCode, String message) {
        return new ExpressionAnalyzer(functionRegistry, typeManager, node -> {
            throw new SemanticException(errorCode, (Node)node, message, new Object[0]);
        }, session);
    }

    private class Visitor
    extends AstVisitor<Type, AnalysisContext> {
        private final TupleDescriptor tupleDescriptor;

        private Visitor(TupleDescriptor tupleDescriptor) {
            this.tupleDescriptor = Objects.requireNonNull(tupleDescriptor, "tupleDescriptor is null");
        }

        public Type process(Node node, @Nullable AnalysisContext context) {
            Type type = (Type)ExpressionAnalyzer.this.expressionTypes.get(node);
            if (type != null) {
                return type;
            }
            return (Type)super.process(node, (Object)context);
        }

        protected Type visitRow(Row node, AnalysisContext context) {
            List types = (List)node.getItems().stream().map(child -> this.process((Node)child, context)).collect(ImmutableCollectors.toImmutableList());
            RowType type = new RowType(types, Optional.empty());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitCurrentTime(CurrentTime node, AnalysisContext context) {
            DateType type;
            if (node.getPrecision() != null) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "non-default precision not yet supported", new Object[0]);
            }
            switch (node.getType()) {
                case DATE: {
                    type = DateType.DATE;
                    break;
                }
                case TIME: {
                    type = TimeWithTimeZoneType.TIME_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIME: {
                    type = TimeType.TIME;
                    break;
                }
                case TIMESTAMP: {
                    type = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE;
                    break;
                }
                case LOCALTIMESTAMP: {
                    type = TimestampType.TIMESTAMP;
                    break;
                }
                default: {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "%s not yet supported", node.getType().getName());
                }
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitQualifiedNameReference(QualifiedNameReference node, AnalysisContext context) {
            List<Field> matches = this.tupleDescriptor.resolveFields(node.getName());
            if (matches.isEmpty()) {
                return this.tryVisitRowFieldAccessor(node);
            }
            if (matches.size() > 1) {
                throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)node, "Column '%s' is ambiguous", node.getName());
            }
            Field field = (Field)Iterables.getOnlyElement(matches);
            int fieldIndex = this.tupleDescriptor.indexOf(field);
            ExpressionAnalyzer.this.resolvedNames.put(node.getName(), fieldIndex);
            ExpressionAnalyzer.this.expressionTypes.put(node, field.getType());
            return field.getType();
        }

        private Type tryVisitRowFieldAccessor(QualifiedNameReference node) {
            if (node.getName().getParts().size() < 2) {
                throw this.createMissingAttributeException(node);
            }
            QualifiedName base = new QualifiedName(node.getName().getParts().subList(0, node.getName().getParts().size() - 1));
            List<Field> matches = this.tupleDescriptor.resolveFields(base);
            if (matches.isEmpty()) {
                throw this.createMissingAttributeException(node);
            }
            if (matches.size() > 1) {
                throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)node, "Column '%s' is ambiguous", node.getName());
            }
            Field field = (Field)Iterables.getOnlyElement(matches);
            if (field.getType() instanceof RowType) {
                RowType rowType = Types.checkType(field.getType(), RowType.class, "field.getType()");
                Type rowFieldType = null;
                for (RowType.RowField rowField : rowType.getFields()) {
                    if (!rowField.getName().equals(Optional.of(node.getName().getSuffix()))) continue;
                    rowFieldType = rowField.getType();
                    break;
                }
                if (rowFieldType == null) {
                    throw this.createMissingAttributeException(node);
                }
                int fieldIndex = this.tupleDescriptor.indexOf(field);
                ExpressionAnalyzer.this.resolvedNames.put(node.getName(), fieldIndex);
                ExpressionAnalyzer.this.expressionTypes.put(node, rowFieldType);
                ExpressionAnalyzer.this.rowFieldReferences.put(node, true);
                return rowFieldType;
            }
            throw this.createMissingAttributeException(node);
        }

        private SemanticException createMissingAttributeException(QualifiedNameReference node) {
            return new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)node, "Column '%s' cannot be resolved", node.getName());
        }

        protected Type visitNotExpression(NotExpression node, AnalysisContext context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitLogicalBinaryExpression(LogicalBinaryExpression node, AnalysisContext context) {
            this.coerceType(context, node.getLeft(), (Type)BooleanType.BOOLEAN, "Left side of logical expression");
            this.coerceType(context, node.getRight(), (Type)BooleanType.BOOLEAN, "Right side of logical expression");
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitComparisonExpression(ComparisonExpression node, AnalysisContext context) {
            OperatorType operatorType = node.getType() == ComparisonExpression.Type.IS_DISTINCT_FROM ? OperatorType.EQUAL : OperatorType.valueOf(node.getType().name());
            return this.getOperator(context, (Expression)node, operatorType, node.getLeft(), node.getRight());
        }

        protected Type visitIsNullPredicate(IsNullPredicate node, AnalysisContext context) {
            this.process((Node)node.getValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, AnalysisContext context) {
            this.process((Node)node.getValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitNullIfExpression(NullIfExpression node, AnalysisContext context) {
            Type secondType;
            Type firstType = this.process((Node)node.getFirst(), context);
            if (!FunctionRegistry.getCommonSuperType(firstType, secondType = this.process((Node)node.getSecond(), context)).isPresent()) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Types are not comparable with NULLIF: %s vs %s", firstType, secondType);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, firstType);
            return firstType;
        }

        protected Type visitIfExpression(IfExpression node, AnalysisContext context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, (Node)node, "Result types for IF must be the same: %s vs %s", node.getTrueValue(), (Expression)node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, AnalysisContext context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                Objects.requireNonNull(whenClauseType, String.format("Expression types does not contain an entry for %s", whenClause));
                ExpressionAnalyzer.this.expressionTypes.put(whenClause, whenClauseType);
            }
            return type;
        }

        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, AnalysisContext context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceToSingleType(context, (Node)node, "CASE operand type does not match WHEN clause operand type: %s vs %s", node.getOperand(), whenClause.getOperand());
            }
            Type type = this.coerceToSingleType(context, "All CASE results must be the same type: %s", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                Objects.requireNonNull(whenClauseType, String.format("Expression types does not contain an entry for %s", whenClause));
                ExpressionAnalyzer.this.expressionTypes.put(whenClause, whenClauseType);
            }
            return type;
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            defaultValue.ifPresent(resultExpressions::add);
            return resultExpressions;
        }

        protected Type visitCoalesceExpression(CoalesceExpression node, AnalysisContext context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands must be the same type: %s", node.getOperands());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitArithmeticUnary(ArithmeticUnaryExpression node, AnalysisContext context) {
            switch (node.getSign()) {
                case PLUS: {
                    Type type = this.process((Node)node.getValue(), context);
                    if (!type.equals(BigintType.BIGINT) && !type.equals(DoubleType.DOUBLE)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unary '+' operator cannot by applied to %s type", type);
                    }
                    ExpressionAnalyzer.this.expressionTypes.put(node, type);
                    return type;
                }
                case MINUS: {
                    return this.getOperator(context, (Expression)node, OperatorType.NEGATION, node.getValue());
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected Type visitArithmeticBinary(ArithmeticBinaryExpression node, AnalysisContext context) {
            return this.getOperator(context, (Expression)node, OperatorType.valueOf(node.getType().name()), node.getLeft(), node.getRight());
        }

        protected Type visitLikePredicate(LikePredicate node, AnalysisContext context) {
            this.coerceType(context, node.getValue(), (Type)VarcharType.VARCHAR, "Left side of LIKE expression");
            this.coerceType(context, node.getPattern(), (Type)VarcharType.VARCHAR, "Pattern for LIKE expression");
            if (node.getEscape() != null) {
                this.coerceType(context, node.getEscape(), (Type)VarcharType.VARCHAR, "Escape for LIKE expression");
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitSubscriptExpression(SubscriptExpression node, AnalysisContext context) {
            return this.getOperator(context, (Expression)node, OperatorType.SUBSCRIPT, node.getBase(), node.getIndex());
        }

        protected Type visitArrayConstructor(ArrayConstructor node, AnalysisContext context) {
            Type type = this.coerceToSingleType(context, "All ARRAY elements must be the same type: %s", node.getValues());
            Type arrayType = ExpressionAnalyzer.this.typeManager.getParameterizedType(ArrayParametricType.ARRAY.getName(), (List)ImmutableList.of((Object)type.getTypeSignature()), (List)ImmutableList.of());
            ExpressionAnalyzer.this.expressionTypes.put(node, arrayType);
            return arrayType;
        }

        protected Type visitStringLiteral(StringLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, VarcharType.VARCHAR);
            return VarcharType.VARCHAR;
        }

        protected Type visitLongLiteral(LongLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, BigintType.BIGINT);
            return BigintType.BIGINT;
        }

        protected Type visitDoubleLiteral(DoubleLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, DoubleType.DOUBLE);
            return DoubleType.DOUBLE;
        }

        protected Type visitBooleanLiteral(BooleanLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitGenericLiteral(GenericLiteral node, AnalysisContext context) {
            Type type = ExpressionAnalyzer.this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (!JsonType.JSON.equals(type)) {
                try {
                    ExpressionAnalyzer.this.functionRegistry.getCoercion((Type)VarcharType.VARCHAR, type);
                }
                catch (IllegalArgumentException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "No literal form for type %s", type);
                }
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitTimeLiteral(TimeLiteral node, AnalysisContext context) {
            Object type = DateTimeUtils.timeHasTimeZone(node.getValue()) ? TimeWithTimeZoneType.TIME_WITH_TIME_ZONE : TimeType.TIME;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitTimestampLiteral(TimestampLiteral node, AnalysisContext context) {
            try {
                DateTimeUtils.parseTimestampLiteral(ExpressionAnalyzer.this.session.getTimeZoneKey(), node.getValue());
            }
            catch (Exception e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid timestamp literal", node.getValue());
            }
            Object type = DateTimeUtils.timestampHasTimeZone(node.getValue()) ? TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE : TimestampType.TIMESTAMP;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitIntervalLiteral(IntervalLiteral node, AnalysisContext context) {
            Object type = node.isYearToMonth() ? IntervalYearMonthType.INTERVAL_YEAR_MONTH : IntervalDayTimeType.INTERVAL_DAY_TIME;
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitNullLiteral(NullLiteral node, AnalysisContext context) {
            ExpressionAnalyzer.this.expressionTypes.put(node, UnknownType.UNKNOWN);
            return UnknownType.UNKNOWN;
        }

        protected Type visitFunctionCall(FunctionCall node, AnalysisContext context) {
            if (node.getWindow().isPresent()) {
                Type type;
                for (Expression expression : ((Window)node.getWindow().get()).getPartitionBy()) {
                    this.process((Node)expression, context);
                    type = (Type)ExpressionAnalyzer.this.expressionTypes.get(expression);
                    if (type.isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in window function PARTITION BY", type);
                }
                for (SortItem sortItem : ((Window)node.getWindow().get()).getOrderBy()) {
                    this.process((Node)sortItem.getSortKey(), context);
                    type = (Type)ExpressionAnalyzer.this.expressionTypes.get(sortItem.getSortKey());
                    if (type.isOrderable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not orderable, and therefore cannot be used in window function ORDER BY", type);
                }
                if (((Window)node.getWindow().get()).getFrame().isPresent()) {
                    Type type2;
                    WindowFrame frame = (WindowFrame)((Window)node.getWindow().get()).getFrame().get();
                    if (frame.getStart().getValue().isPresent() && !(type2 = this.process((Node)frame.getStart().getValue().get(), context)).equals(BigintType.BIGINT)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Window frame start value type must be BIGINT (actual %s)", type2);
                    }
                    if (frame.getEnd().isPresent() && ((FrameBound)frame.getEnd().get()).getValue().isPresent() && !(type2 = this.process((Node)((FrameBound)frame.getEnd().get()).getValue().get(), context)).equals(BigintType.BIGINT)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Window frame end value type must be BIGINT (actual %s)", type2);
                    }
                }
            }
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : node.getArguments()) {
                argumentTypes.add((Object)this.process((Node)expression, context).getTypeSignature());
            }
            Signature function = ExpressionAnalyzer.this.functionRegistry.resolveFunction(node.getName(), (List<TypeSignature>)argumentTypes.build(), context.isApproximate());
            for (int i = 0; i < node.getArguments().size(); ++i) {
                Expression expression = (Expression)node.getArguments().get(i);
                Type type = ExpressionAnalyzer.this.typeManager.getType(function.getArgumentTypes().get(i));
                Objects.requireNonNull(type, String.format("Type %s not found", function.getArgumentTypes().get(i)));
                if (node.isDistinct() && !type.isComparable()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "DISTINCT can only be applied to comparable types (actual: %s)", type);
                }
                this.coerceType(context, expression, type, String.format("Function %s argument %d", function, i));
            }
            ExpressionAnalyzer.this.resolvedFunctions.put(node, function);
            Type type = ExpressionAnalyzer.this.typeManager.getType(function.getReturnType());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitExtract(Extract node, AnalysisContext context) {
            Type type = this.process((Node)node.getExpression(), context);
            if (!this.isDateTimeType(type)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract must be DATE, TIME, TIMESTAMP, or INTERVAL (actual %s)", type);
            }
            Extract.Field field = node.getField();
            if (!(field != Extract.Field.TIMEZONE_HOUR && field != Extract.Field.TIMEZONE_MINUTE || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE))) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getExpression(), "Type of argument to extract time zone field must have a time zone (actual %s)", type);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BigintType.BIGINT);
            return BigintType.BIGINT;
        }

        private boolean isDateTimeType(Type type) {
            return type.equals(DateType.DATE) || type.equals(TimeType.TIME) || type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) || type.equals(TimestampType.TIMESTAMP) || type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE) || type.equals(IntervalDayTimeType.INTERVAL_DAY_TIME) || type.equals(IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        }

        protected Type visitBetweenPredicate(BetweenPredicate node, AnalysisContext context) {
            return this.getOperator(context, (Expression)node, OperatorType.BETWEEN, node.getValue(), node.getMin(), node.getMax());
        }

        public Type visitCast(Cast node, AnalysisContext context) {
            Type type = ExpressionAnalyzer.this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (type.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "UNKNOWN is not a valid type", new Object[0]);
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (!value.equals((Object)UnknownType.UNKNOWN)) {
                try {
                    ExpressionAnalyzer.this.functionRegistry.getCoercion(value, type);
                }
                catch (OperatorNotFoundException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Cannot cast %s to %s", value, type);
                }
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitInPredicate(InPredicate node, AnalysisContext context) {
            Expression value = node.getValue();
            this.process((Node)value, context);
            Expression valueList = node.getValueList();
            this.process((Node)valueList, context);
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                this.coerceToSingleType(context, "IN value and list items must be the same type: %s", (List<Expression>)ImmutableList.builder().add((Object)value).addAll((Iterable)inListExpression.getValues()).build());
            } else if (valueList instanceof SubqueryExpression) {
                this.coerceToSingleType(context, (Node)node, "value and result of subquery must be of the same type for IN expression: %s vs %s", value, valueList);
                ExpressionAnalyzer.this.subqueryInPredicates.add(node);
            }
            ExpressionAnalyzer.this.expressionTypes.put(node, BooleanType.BOOLEAN);
            return BooleanType.BOOLEAN;
        }

        protected Type visitInListExpression(InListExpression node, AnalysisContext context) {
            Type type = this.coerceToSingleType(context, "All IN list values must be the same type: %s", node.getValues());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitSubqueryExpression(SubqueryExpression node, AnalysisContext context) {
            StatementAnalyzer analyzer = (StatementAnalyzer)((Object)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node));
            TupleDescriptor descriptor = (TupleDescriptor)analyzer.process((Node)node.getQuery(), context);
            if (descriptor.getVisibleFieldCount() != 1) {
                throw new SemanticException(SemanticErrorCode.MULTIPLE_FIELDS_FROM_SCALAR_SUBQUERY, (Node)node, "Subquery expression must produce only one field. Found %s", descriptor.getVisibleFieldCount());
            }
            Type type = ((Field)Iterables.getOnlyElement(descriptor.getVisibleFields())).getType();
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        public Type visitInputReference(InputReference node, AnalysisContext context) {
            Type type = this.tupleDescriptor.getFieldByIndex(node.getChannel()).getType();
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        protected Type visitExpression(Expression node, AnalysisContext context) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "not yet implemented: " + node.getClass().getName(), new Object[0]);
        }

        private Type getOperator(AnalysisContext context, Expression node, OperatorType operatorType, Expression ... arguments) {
            Signature operatorSignature;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                operatorSignature = ExpressionAnalyzer.this.functionRegistry.resolveOperator(operatorType, (List<? extends Type>)argumentTypes.build());
            }
            catch (OperatorNotFoundException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, e.getMessage(), new Object[0]);
            }
            for (int i = 0; i < arguments.length; ++i) {
                Expression expression = arguments[i];
                Type type = ExpressionAnalyzer.this.typeManager.getType(operatorSignature.getArgumentTypes().get(i));
                this.coerceType(context, expression, type, String.format("Operator %s argument %d", operatorSignature, i));
            }
            Type type = ExpressionAnalyzer.this.typeManager.getType(operatorSignature.getReturnType());
            ExpressionAnalyzer.this.expressionTypes.put(node, type);
            return type;
        }

        private void coerceType(AnalysisContext context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            if (!actualType.equals(expectedType)) {
                if (!FunctionRegistry.canCoerce(actualType, expectedType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message + " must evaluate to a %s (actual: %s)", expectedType, actualType);
                }
                ExpressionAnalyzer.this.expressionCoercions.put(expression, expectedType);
            }
        }

        private Type coerceToSingleType(AnalysisContext context, Node node, String message, Expression first, Expression second) {
            Type firstType = null;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            Type secondType = null;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if (firstType == null) {
                return secondType;
            }
            if (secondType == null) {
                return firstType;
            }
            if (firstType.equals(secondType)) {
                return firstType;
            }
            if (FunctionRegistry.canCoerce(firstType, secondType)) {
                ExpressionAnalyzer.this.expressionCoercions.put(first, secondType);
                return secondType;
            }
            if (FunctionRegistry.canCoerce(secondType, firstType)) {
                ExpressionAnalyzer.this.expressionCoercions.put(second, firstType);
                return firstType;
            }
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, node, message, firstType, secondType);
        }

        private Type coerceToSingleType(AnalysisContext context, String message, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            for (Expression expression : expressions) {
                Optional<Type> newSuperType = FunctionRegistry.getCommonSuperType((Type)superType, this.process((Node)expression, context));
                if (!newSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                superType = newSuperType.get();
            }
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                if (type.equals((Object)superType)) continue;
                if (!FunctionRegistry.canCoerce(type, (Type)superType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, message, new Object[]{superType});
                }
                ExpressionAnalyzer.this.expressionCoercions.put(expression, superType);
            }
            return superType;
        }
    }

    private static class ScalarSubqueryDetector
    extends DefaultTraversalVisitor<Void, Void> {
        private ScalarSubqueryDetector() {
        }

        protected Void visitInPredicate(InPredicate node, Void context) {
            Expression valueList = node.getValueList();
            if (valueList instanceof SubqueryExpression) {
                this.process((Node)node.getValue(), context);
                super.visitSubqueryExpression((SubqueryExpression)valueList, (Object)context);
            } else {
                super.visitInPredicate(node, (Object)context);
            }
            return null;
        }

        protected Void visitSubqueryExpression(SubqueryExpression node, Void context) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Scalar subqueries not yet supported", new Object[0]);
        }
    }
}

