/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.TupleDescriptor;
import com.facebook.presto.sql.tree.Query;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

public class AnalysisContext {
    private final AnalysisContext parent;
    private final Map<String, Query> namedQueries = new HashMap<String, Query>();
    private TupleDescriptor lateralTupleDescriptor = new TupleDescriptor(new Field[0]);
    private boolean approximate;

    public AnalysisContext(AnalysisContext parent) {
        this.parent = parent;
        this.approximate = parent.approximate;
    }

    public AnalysisContext() {
        this.parent = null;
    }

    public void setLateralTupleDescriptor(TupleDescriptor lateralTupleDescriptor) {
        this.lateralTupleDescriptor = lateralTupleDescriptor;
    }

    public TupleDescriptor getLateralTupleDescriptor() {
        return this.lateralTupleDescriptor;
    }

    public boolean isApproximate() {
        return this.approximate;
    }

    public void setApproximate(boolean approximate) {
        this.approximate = approximate;
    }

    public void addNamedQuery(String name, Query query) {
        Preconditions.checkState((!this.namedQueries.containsKey(name) ? 1 : 0) != 0, (String)"Named query already registered: %s", (Object[])new Object[]{name});
        this.namedQueries.put(name, query);
    }

    public Query getNamedQuery(String name) {
        Query result = this.namedQueries.get(name);
        if (result == null && this.parent != null) {
            return this.parent.getNamedQuery(name);
        }
        return result;
    }

    public boolean isNamedQueryDeclared(String name) {
        return this.namedQueries.containsKey(name);
    }
}

