/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.LegacyTableLayoutHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.split.ConnectorAwareSplitSource;
import com.facebook.presto.split.SplitSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SplitManager {
    private final ConcurrentMap<String, ConnectorSplitManager> splitManagers = new ConcurrentHashMap<String, ConnectorSplitManager>();

    public void addConnectorSplitManager(String connectorId, ConnectorSplitManager connectorSplitManager) {
        Preconditions.checkState((this.splitManagers.putIfAbsent(connectorId, connectorSplitManager) == null ? 1 : 0) != 0, (String)"SplitManager for connector '%s' is already registered", (Object[])new Object[]{connectorId});
    }

    public SplitSource getSplits(Session session, TableLayoutHandle layout) {
        ConnectorSplitSource source;
        String connectorId = layout.getConnectorId();
        ConnectorSplitManager splitManager = this.getConnectorSplitManager(connectorId);
        ConnectorSession connectorSession = session.toConnectorSession(connectorId);
        if (layout.getConnectorHandle() instanceof LegacyTableLayoutHandle) {
            LegacyTableLayoutHandle handle = (LegacyTableLayoutHandle)layout.getConnectorHandle();
            if (handle.getPartitions().isEmpty()) {
                return new ConnectorAwareSplitSource(connectorId, (ConnectorSplitSource)new FixedSplitSource(connectorId, (Iterable)ImmutableList.of()));
            }
            source = splitManager.getPartitionSplits(connectorSession, handle.getTable(), handle.getPartitions());
        } else {
            source = splitManager.getSplits(connectorSession, layout.getConnectorHandle());
        }
        return new ConnectorAwareSplitSource(connectorId, source);
    }

    public ConnectorSplitManager getConnectorSplitManager(String connectorId) {
        ConnectorSplitManager result = (ConnectorSplitManager)this.splitManagers.get(connectorId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (String)"No split manager for connector '%s'", (Object[])new Object[]{connectorId});
        return result;
    }
}

