/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.security.ConnectorAccessControl;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AccessControlManager
implements AccessControl {
    private final Set<SystemAccessControl> systemAccessControllers = Sets.newConcurrentHashSet();
    private final Map<String, ConnectorAccessControl> catalogAccessControl = new ConcurrentHashMap<String, ConnectorAccessControl>();

    public void addSystemAccessControl(SystemAccessControl accessControl) {
        Objects.requireNonNull(accessControl, "accessControl is null");
        this.systemAccessControllers.add(accessControl);
    }

    public void addCatalogAccessControl(String catalogName, ConnectorAccessControl accessControl) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(accessControl, "accessControl is null");
        if (this.catalogAccessControl.putIfAbsent(catalogName, accessControl) != null) {
            throw new IllegalArgumentException(String.format("Access control for catalog '%s' is already registered", catalogName));
        }
    }

    @Override
    public void checkCanSetUser(Principal principal, String userName) {
        Objects.requireNonNull(userName, "userName is null");
        for (SystemAccessControl accessControl : this.systemAccessControllers) {
            accessControl.checkCanSetUser(principal, userName);
        }
    }

    @Override
    public void checkCanCreateTable(Identity identity, QualifiedTableName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanCreateTable(identity, tableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanDropTable(Identity identity, QualifiedTableName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanDropTable(identity, tableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanRenameTable(Identity identity, QualifiedTableName tableName, QualifiedTableName newTableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(newTableName, "newTableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanRenameTable(identity, tableName.asSchemaTableName(), newTableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanAddColumns(Identity identity, QualifiedTableName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanAddColumn(identity, tableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanRenameColumn(Identity identity, QualifiedTableName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanRenameColumn(identity, tableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanSelectFromTable(Identity identity, QualifiedTableName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanSelectFromTable(identity, tableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanInsertIntoTable(Identity identity, QualifiedTableName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanInsertIntoTable(identity, tableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanDeleteFromTable(Identity identity, QualifiedTableName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanDeleteFromTable(identity, tableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanCreateView(Identity identity, QualifiedTableName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(viewName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanCreateView(identity, viewName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanDropView(Identity identity, QualifiedTableName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(viewName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanDropView(identity, viewName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanSelectFromView(Identity identity, QualifiedTableName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(viewName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanSelectFromView(identity, viewName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromTable(Identity identity, QualifiedTableName tableName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(tableName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanCreateViewWithSelectFromTable(identity, tableName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromView(Identity identity, QualifiedTableName viewName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(viewName, "viewName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(viewName.getCatalogName());
        if (accessControl != null) {
            accessControl.checkCanCreateViewWithSelectFromView(identity, viewName.asSchemaTableName());
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        for (SystemAccessControl accessControl : this.systemAccessControllers) {
            accessControl.checkCanSetSystemSessionProperty(identity, propertyName);
        }
    }

    @Override
    public void checkCanSetCatalogSessionProperty(Identity identity, String catalogName, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        ConnectorAccessControl accessControl = this.catalogAccessControl.get(catalogName);
        if (accessControl != null) {
            accessControl.checkCanSetCatalogSessionProperty(identity, propertyName);
        }
    }
}

