/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.window.ValueWindowFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.util.Failures;
import com.google.common.primitives.Ints;
import java.util.List;

public class NthValueFunction
extends ValueWindowFunction {
    private final int valueChannel;
    private final int offsetChannel;

    public NthValueFunction(List<Integer> argumentChannels) {
        this.valueChannel = argumentChannels.get(0);
        this.offsetChannel = argumentChannels.get(1);
    }

    @Override
    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        if (frameStart < 0 || this.windowIndex.isNull(this.offsetChannel, currentPosition)) {
            output.appendNull();
        } else {
            long offset = this.windowIndex.getLong(this.offsetChannel, currentPosition);
            Failures.checkCondition(offset >= 1L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Offset must be at least 1", new Object[0]);
            long valuePosition = (long)frameStart + (offset - 1L);
            if (valuePosition >= (long)frameStart && valuePosition <= (long)frameEnd) {
                this.windowIndex.appendTo(this.valueChannel, Ints.checkedCast((long)valuePosition), output);
            } else {
                output.appendNull();
            }
        }
    }
}

