/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Map;

public class TryCastFunction
implements ParametricFunction {
    public static final TryCastFunction TRY_CAST = new TryCastFunction();
    private static final Signature SIGNATURE = new Signature("TRY_CAST", FunctionType.SCALAR, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("F"), (Object)Signature.typeParameter("T")), "T", (List<String>)ImmutableList.of((Object)"F"), false);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        MethodHandle tryCastHandle;
        Type fromType = types.get("F");
        Type toType = types.get("T");
        Class returnType = Primitives.wrap((Class)toType.getJavaType());
        if (fromType.equals((Object)UnknownType.UNKNOWN)) {
            tryCastHandle = MethodHandles.dropArguments(MethodHandles.constant(returnType, null), 0, new Class[]{Void.class});
        } else {
            Signature signature = functionRegistry.getCoercion(fromType, toType);
            MethodHandle coercion = functionRegistry.getScalarFunctionImplementation(signature).getMethodHandle();
            coercion = coercion.asType(MethodType.methodType(returnType, coercion.type()));
            MethodHandle exceptionHandler = MethodHandles.dropArguments(MethodHandles.constant(returnType, null), 0, new Class[]{RuntimeException.class});
            tryCastHandle = MethodHandles.catchException(coercion, RuntimeException.class, exceptionHandler);
        }
        return new FunctionInfo(Signature.internalScalarFunction(SIGNATURE.getName(), toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature())), this.getDescription(), this.isHidden(), tryCastHandle, this.isDeterministic(), true, (List<Boolean>)ImmutableList.of((Object)true));
    }
}

