/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.TypeJsonUtils;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class JsonToArrayCast
extends ParametricOperator {
    public static final JsonToArrayCast JSON_TO_ARRAY = new JsonToArrayCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToArrayCast.class, "toArray", Type.class, ConnectorSession.class, Slice.class);

    private JsonToArrayCast() {
        super(OperatorType.CAST, (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("T")), "array<T>", (List<String>)ImmutableList.of((Object)"json"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = types.get("T");
        Type arrayType = typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)type.getTypeSignature()), (List)ImmutableList.of());
        Failures.checkCondition(TypeJsonUtils.canCastFromJson(arrayType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", arrayType);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(arrayType);
        return FunctionRegistry.operatorInfo(OperatorType.CAST, arrayType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)TypeUtils.parameterizedTypeName("json", new TypeSignature[0])), methodHandle, true, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static Block toArray(Type arrayType, ConnectorSession connectorSession, Slice json) {
        try {
            List array = (List)TypeJsonUtils.stackRepresentationToObject(connectorSession, json, arrayType);
            if (array == null) {
                return null;
            }
            Type elementType = ((ArrayType)arrayType).getElementType();
            BlockBuilder blockBuilder = elementType.createBlockBuilder(new BlockBuilderStatus(), array.size());
            for (Object element : array) {
                TypeJsonUtils.appendToBlockBuilder(elementType, element, blockBuilder);
            }
            return blockBuilder.build();
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to " + arrayType, (Throwable)e);
        }
    }
}

