/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class ConcatFunction
implements ParametricFunction {
    public static final ConcatFunction CONCAT = new ConcatFunction();
    private static final Signature SIGNATURE = new Signature("concat", FunctionType.SCALAR, (List<TypeParameter>)ImmutableList.of(), "varchar", (List<String>)ImmutableList.of((Object)"varchar"), true);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "concatenates given strings";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        if (arity < 2) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments");
        }
        Class<?> clazz = ConcatFunction.generateConcat(arity);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, "concat", Collections.nCopies(arity, Slice.class).toArray(new Class[arity]));
        ImmutableList nullableParameters = ImmutableList.copyOf(Collections.nCopies(arity, false));
        Signature specializedSignature = Signature.internalScalarFunction(SIGNATURE.getName(), VarcharType.VARCHAR.getTypeSignature(), Collections.nCopies(arity, VarcharType.VARCHAR.getTypeSignature()));
        return new FunctionInfo(specializedSignature, this.getDescription(), this.isHidden(), methodHandle, this.isDeterministic(), false, (List<Boolean>)nullableParameters);
    }

    private static Class<?> generateConcat(int arity) {
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("Concat" + arity + "ScalarFunction"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a(Access.PRIVATE));
        List parameters = (List)IntStream.range(0, arity).mapToObj(i -> Parameter.arg("arg" + i, Slice.class)).collect(ImmutableCollectors.toImmutableList());
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC, Access.STATIC), "concat", ParameterizedType.type(Slice.class), parameters);
        Scope scope = method.getScope();
        ByteCodeBlock body = method.getBody();
        Variable length = scope.declareVariable(Integer.TYPE, "length");
        body.append(length.set(ByteCodeExpressions.constantInt(0)));
        for (int i2 = 0; i2 < arity; ++i2) {
            body.append(length.set(ConcatFunction.generateCheckedAdd(length, ((Parameter)parameters.get(i2)).invoke("length", Integer.TYPE, new ByteCodeExpression[0]))));
        }
        Variable result = scope.declareVariable(Slice.class, "result");
        body.append(result.set(ByteCodeExpressions.invokeStatic(Slices.class, "allocate", Slice.class, length)));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.append(position.set(ByteCodeExpressions.constantInt(0)));
        for (int i3 = 0; i3 < arity; ++i3) {
            body.append(result.invoke("setBytes", Void.TYPE, position, (ByteCodeExpression)parameters.get(i3)));
            body.append(position.set(ByteCodeExpressions.add(position, ((Parameter)parameters.get(i3)).invoke("length", Integer.TYPE, new ByteCodeExpression[0]))));
        }
        body.getVariable(result).retObject();
        return CompilerUtils.defineClass(definition, Object.class, (Map<Long, MethodHandle>)ImmutableMap.of(), new DynamicClassLoader(ConcatFunction.class.getClassLoader()));
    }

    private static ByteCodeExpression generateCheckedAdd(ByteCodeExpression x, ByteCodeExpression y) {
        return ByteCodeExpressions.invokeStatic(ConcatFunction.class, "checkedAdd", Integer.TYPE, x, y);
    }

    public static int checkedAdd(int x, int y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Concatenated string is too large");
        }
    }
}

