/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricOperator;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayHashCodeOperator
extends ParametricOperator {
    public static final ArrayHashCodeOperator ARRAY_HASH_CODE = new ArrayHashCodeOperator();
    private static final TypeSignature RETURN_TYPE = TypeSignature.parseTypeSignature((String)"bigint");
    public static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayHashCodeOperator.class, "hash", Type.class, Block.class);

    private ArrayHashCodeOperator() {
        super(OperatorType.HASH_CODE, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), "bigint", (List<String>)ImmutableList.of((Object)"array<T>"));
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type type = types.get("T");
        type = typeManager.getParameterizedType("array", (List)ImmutableList.of((Object)type.getTypeSignature()), (List)ImmutableList.of());
        TypeSignature typeSignature = type.getTypeSignature();
        return FunctionRegistry.operatorInfo(OperatorType.HASH_CODE, RETURN_TYPE, (List<TypeSignature>)ImmutableList.of((Object)typeSignature), METHOD_HANDLE.bindTo(type), false, (List<Boolean>)ImmutableList.of((Object)false));
    }

    public static long hash(Type type, Block block) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1);
        blockBuilder.writeObject((Object)block).closeEntry();
        return type.hash(blockBuilder.build(), 0);
    }
}

