/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.Parameter;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Scope;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateMetadata;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.InitialBooleanValue;
import com.facebook.presto.operator.aggregation.state.InitialDoubleValue;
import com.facebook.presto.operator.aggregation.state.InitialLongValue;
import com.facebook.presto.operator.aggregation.state.StateCompilerUtils;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.facebook.presto.util.array.BlockBigArray;
import com.facebook.presto.util.array.BooleanBigArray;
import com.facebook.presto.util.array.ByteBigArray;
import com.facebook.presto.util.array.DoubleBigArray;
import com.facebook.presto.util.array.LongBigArray;
import com.facebook.presto.util.array.SliceBigArray;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openjdk.jol.info.ClassLayout;

public class StateCompiler {
    private static Class<?> getBigArrayType(Class<?> type) {
        if (type.equals(Long.TYPE)) {
            return LongBigArray.class;
        }
        if (type.equals(Byte.TYPE)) {
            return ByteBigArray.class;
        }
        if (type.equals(Double.TYPE)) {
            return DoubleBigArray.class;
        }
        if (type.equals(Boolean.TYPE)) {
            return BooleanBigArray.class;
        }
        if (type.equals(Slice.class)) {
            return SliceBigArray.class;
        }
        if (type.equals(Block.class)) {
            return BlockBigArray.class;
        }
        throw new IllegalArgumentException("Unsupported type: " + type.getName());
    }

    public <T> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz) {
        return this.generateStateSerializer(clazz, new DynamicClassLoader(clazz.getClassLoader()));
    }

    public <T> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz, DynamicClassLoader classLoader) {
        AccumulatorStateMetadata metadata = StateCompiler.getMetadataAnnotation(clazz);
        if (metadata != null && metadata.stateSerializerClass() != Void.TYPE) {
            try {
                return (AccumulatorStateSerializer)metadata.stateSerializerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(clazz.getSimpleName() + "Serializer"), ParameterizedType.type(Object.class), ParameterizedType.type(AccumulatorStateSerializer.class));
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        definition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        List<StateField> fields = StateCompiler.enumerateFields(clazz);
        StateCompiler.generateGetSerializedType(definition, fields, callSiteBinder);
        StateCompiler.generateSerialize(definition, clazz, fields);
        StateCompiler.generateDeserialize(definition, clazz, fields);
        Class<AccumulatorStateSerializer> serializerClass = CompilerUtils.defineClass(definition, AccumulatorStateSerializer.class, callSiteBinder.getBindings(), classLoader);
        try {
            return serializerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void generateGetSerializedType(ClassDefinition definition, List<StateField> fields, CallSiteBinder callSiteBinder) {
        VarcharType type;
        ByteCodeBlock body = definition.declareMethod(Access.a(Access.PUBLIC), "getSerializedType", ParameterizedType.type(Type.class), new Parameter[0]).getBody();
        if (fields.size() > 1) {
            type = VarcharType.VARCHAR;
        } else {
            Class<?> stackType = fields.get(0).getType();
            if (stackType == Long.TYPE) {
                type = BigintType.BIGINT;
            } else if (stackType == Double.TYPE) {
                type = DoubleType.DOUBLE;
            } else if (stackType == Boolean.TYPE) {
                type = BooleanType.BOOLEAN;
            } else if (stackType == Byte.TYPE) {
                type = BigintType.BIGINT;
            } else if (stackType == Slice.class) {
                type = VarcharType.VARCHAR;
            } else {
                throw new IllegalArgumentException("Unsupported type: " + stackType);
            }
        }
        body.comment("return %s", type.getTypeSignature()).append(SqlTypeByteCodeExpression.constantType(callSiteBinder, (Type)type)).retObject();
    }

    private static <T> AccumulatorStateMetadata getMetadataAnnotation(Class<T> clazz) {
        AccumulatorStateMetadata metadata = clazz.getAnnotation(AccumulatorStateMetadata.class);
        if (metadata != null) {
            return metadata;
        }
        for (Class<?> superInterface : clazz.getInterfaces()) {
            metadata = superInterface.getAnnotation(AccumulatorStateMetadata.class);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }

    private static <T> void generateDeserialize(ClassDefinition definition, Class<T> clazz, List<StateField> fields) {
        Parameter block = Parameter.arg("block", Block.class);
        Parameter index = Parameter.arg("index", Integer.TYPE);
        Parameter state = Parameter.arg("state", Object.class);
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC), "deserialize", ParameterizedType.type(Void.TYPE), block, index, state);
        ByteCodeBlock deserializerBody = method.getBody();
        if (fields.size() == 1) {
            Method setter = StateCompiler.getSetter(clazz, fields.get(0));
            Method blockGetter = StateCompilerUtils.getBlockGetter(setter.getParameterTypes()[0]);
            deserializerBody.append(state.cast(setter.getDeclaringClass()).invoke(setter, ByteCodeExpressions.invokeStatic(blockGetter, block, index)));
        } else {
            Variable slice = method.getScope().declareVariable(Slice.class, "slice");
            deserializerBody.append(slice.set(block.invoke("getSlice", Slice.class, index, ByteCodeExpressions.constantInt(0), block.invoke("getLength", Integer.TYPE, index))));
            for (StateField field : fields) {
                Method setter = StateCompiler.getSetter(clazz, field);
                Method getter = StateCompilerUtils.getSliceGetter(setter.getParameterTypes()[0]);
                int offset = StateCompiler.offsetOfField(field, fields);
                deserializerBody.append(state.cast(setter.getDeclaringClass()).invoke(setter, ByteCodeExpressions.invokeStatic(getter, slice, ByteCodeExpressions.constantInt(offset))));
            }
        }
        deserializerBody.ret();
    }

    private static <T> void generateSerialize(ClassDefinition definition, Class<T> clazz, List<StateField> fields) {
        Parameter state = Parameter.arg("state", Object.class);
        Parameter out = Parameter.arg("out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a(Access.PUBLIC), "serialize", ParameterizedType.type(Void.TYPE), state, out);
        ByteCodeBlock serializerBody = method.getBody();
        if (fields.size() == 1) {
            Method getter = StateCompiler.getGetter(clazz, fields.get(0));
            Method append = StateCompilerUtils.getBlockBuilderAppend(getter.getReturnType());
            serializerBody.append(ByteCodeExpressions.invokeStatic(append, out, state.cast(getter.getDeclaringClass()).invoke(getter, new ByteCodeExpression[0])));
        } else {
            Variable slice = method.getScope().declareVariable(Slice.class, "slice");
            ByteCodeExpression size = ByteCodeExpressions.constantInt(StateCompiler.serializedSizeOf(clazz));
            serializerBody.append(slice.set(ByteCodeExpressions.invokeStatic(Slices.class, "allocate", Slice.class, size)));
            for (StateField field : fields) {
                Method getter = StateCompiler.getGetter(clazz, field);
                Method sliceSetter = StateCompilerUtils.getSliceSetter(getter.getReturnType());
                serializerBody.append(ByteCodeExpressions.invokeStatic(sliceSetter, slice, ByteCodeExpressions.constantInt(StateCompiler.offsetOfField(field, fields)), state.cast(getter.getDeclaringClass()).invoke(getter, new ByteCodeExpression[0])));
            }
            serializerBody.append(out.invoke("writeBytes", BlockBuilder.class, slice, ByteCodeExpressions.constantInt(0), size).invoke("closeEntry", BlockBuilder.class, new ByteCodeExpression[0]).pop());
        }
        serializerBody.ret();
    }

    private static int offsetOfField(StateField targetField, List<StateField> fields) {
        int offset = 0;
        for (StateField field : fields) {
            if (targetField.getName().equals(field.getName())) break;
            offset += field.sizeOfType();
        }
        return offset;
    }

    private static int serializedSizeOf(Class<?> stateClass) {
        List<StateField> fields = StateCompiler.enumerateFields(stateClass);
        int size = 0;
        for (StateField field : fields) {
            size += field.sizeOfType();
        }
        return size;
    }

    private static Method getSetter(Class<?> clazz, StateField field) {
        try {
            return clazz.getMethod(field.getSetterName(), field.getType());
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Method getGetter(Class<?> clazz, StateField field) {
        try {
            return clazz.getMethod(field.getGetterName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public <T> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz) {
        return this.generateStateFactory(clazz, new DynamicClassLoader(clazz.getClassLoader()));
    }

    public <T> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz, DynamicClassLoader classLoader) {
        AccumulatorStateMetadata metadata = StateCompiler.getMetadataAnnotation(clazz);
        if (metadata != null && metadata.stateFactoryClass() != Void.TYPE) {
            try {
                return (AccumulatorStateFactory)metadata.stateFactoryClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        Class<T> singleStateClass = StateCompiler.generateSingleStateClass(clazz, classLoader);
        Class<T> groupedStateClass = StateCompiler.generateGroupedStateClass(clazz, classLoader);
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(clazz.getSimpleName() + "Factory"), ParameterizedType.type(Object.class), ParameterizedType.type(AccumulatorStateFactory.class));
        definition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        definition.declareMethod(Access.a(Access.PUBLIC), "createSingleState", ParameterizedType.type(Object.class), new Parameter[0]).getBody().newObject(singleStateClass).dup().invokeConstructor(singleStateClass, new Class[0]).retObject();
        definition.declareMethod(Access.a(Access.PUBLIC), "createGroupedState", ParameterizedType.type(Object.class), new Parameter[0]).getBody().newObject(groupedStateClass).dup().invokeConstructor(groupedStateClass, new Class[0]).retObject();
        definition.declareMethod(Access.a(Access.PUBLIC), "getSingleStateClass", ParameterizedType.type(Class.class, singleStateClass), new Parameter[0]).getBody().push(singleStateClass).retObject();
        definition.declareMethod(Access.a(Access.PUBLIC), "getGroupedStateClass", ParameterizedType.type(Class.class, groupedStateClass), new Parameter[0]).getBody().push(groupedStateClass).retObject();
        Class<AccumulatorStateFactory> factoryClass = CompilerUtils.defineClass(definition, AccumulatorStateFactory.class, classLoader);
        try {
            return factoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static <T> Class<? extends T> generateSingleStateClass(Class<T> clazz, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("Single" + clazz.getSimpleName()), ParameterizedType.type(Object.class), ParameterizedType.type(clazz));
        FieldDefinition classSize = definition.declareField(Access.a(Access.PRIVATE, Access.STATIC, Access.FINAL), "CLASS_SIZE", Long.TYPE);
        definition.getClassInitializer().getBody().comment("CLASS_SIZE = ClassLayout.parseClass(%s.class).instanceSize()", definition.getName()).push(definition.getType()).invokeStatic(ClassLayout.class, "parseClass", ClassLayout.class, Class.class).invokeVirtual(ClassLayout.class, "instanceSize", Integer.TYPE, new Class[0]).intToLong().putStaticField(classSize);
        definition.declareMethod(Access.a(Access.PUBLIC), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]).getBody().getStaticField(classSize).retLong();
        MethodDefinition constructor = definition.declareConstructor(Access.a(Access.PUBLIC), new Parameter[0]);
        constructor.getBody().append(constructor.getThis()).invokeConstructor(Object.class, new Class[0]);
        List<StateField> fields = StateCompiler.enumerateFields(clazz);
        for (StateField field : fields) {
            StateCompiler.generateField(definition, constructor, field);
        }
        constructor.getBody().ret();
        return CompilerUtils.defineClass(definition, clazz, classLoader);
    }

    private static <T> Class<? extends T> generateGroupedStateClass(Class<T> clazz, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("Grouped" + clazz.getSimpleName()), ParameterizedType.type(AbstractGroupedAccumulatorState.class), ParameterizedType.type(clazz), ParameterizedType.type(GroupedAccumulator.class));
        List<StateField> fields = StateCompiler.enumerateFields(clazz);
        MethodDefinition constructor = definition.declareConstructor(Access.a(Access.PUBLIC), new Parameter[0]);
        constructor.getBody().append(constructor.getThis()).invokeConstructor(AbstractGroupedAccumulatorState.class, new Class[0]);
        MethodDefinition ensureCapacity = definition.declareMethod(Access.a(Access.PUBLIC), "ensureCapacity", ParameterizedType.type(Void.TYPE), Parameter.arg("size", Long.TYPE));
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (StateField field : fields) {
            fieldDefinitions.add(StateCompiler.generateGroupedField(definition, constructor, ensureCapacity, field));
        }
        constructor.getBody().ret();
        ensureCapacity.getBody().ret();
        MethodDefinition getEstimatedSize = definition.declareMethod(Access.a(Access.PUBLIC), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        ByteCodeBlock body = getEstimatedSize.getBody();
        Variable size = getEstimatedSize.getScope().declareVariable(Long.TYPE, "size");
        body.append(size.set(ByteCodeExpressions.constantLong(0L)));
        for (FieldDefinition field : fieldDefinitions) {
            body.append(size.set(ByteCodeExpressions.add(size, getEstimatedSize.getThis().getField(field).invoke("sizeOf", Long.TYPE, new ByteCodeExpression[0]))));
        }
        body.append(size.ret());
        return CompilerUtils.defineClass(definition, clazz, classLoader);
    }

    private static void generateField(ClassDefinition definition, MethodDefinition constructor, StateField stateField) {
        FieldDefinition field = definition.declareField(Access.a(Access.PRIVATE), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stateField.getName()) + "Value", stateField.getType());
        MethodDefinition getter = definition.declareMethod(Access.a(Access.PUBLIC), stateField.getGetterName(), ParameterizedType.type(stateField.getType()), new Parameter[0]);
        getter.getBody().append(getter.getThis().getField(field).ret());
        Parameter value = Parameter.arg("value", stateField.getType());
        MethodDefinition setter = definition.declareMethod(Access.a(Access.PUBLIC), stateField.getSetterName(), ParameterizedType.type(Void.TYPE), value);
        setter.getBody().append(setter.getThis().setField(field, (ByteCodeExpression)value)).ret();
        constructor.getBody().append(constructor.getThis().setField(field, stateField.initialValueExpression()));
    }

    private static FieldDefinition generateGroupedField(ClassDefinition definition, MethodDefinition constructor, MethodDefinition ensureCapacity, StateField stateField) {
        Class<?> bigArrayType = StateCompiler.getBigArrayType(stateField.getType());
        FieldDefinition field = definition.declareField(Access.a(Access.PRIVATE), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stateField.getName()) + "Values", bigArrayType);
        MethodDefinition getter = definition.declareMethod(Access.a(Access.PUBLIC), stateField.getGetterName(), ParameterizedType.type(stateField.getType()), new Parameter[0]);
        getter.getBody().append(getter.getThis().getField(field).invoke("get", stateField.getType(), getter.getThis().invoke("getGroupId", Long.TYPE, new ByteCodeExpression[0])).ret());
        Parameter value = Parameter.arg("value", stateField.getType());
        MethodDefinition setter = definition.declareMethod(Access.a(Access.PUBLIC), stateField.getSetterName(), ParameterizedType.type(Void.TYPE), value);
        setter.getBody().append(setter.getThis().getField(field).invoke("set", Void.TYPE, setter.getThis().invoke("getGroupId", Long.TYPE, new ByteCodeExpression[0]), value)).ret();
        Scope ensureCapacityScope = ensureCapacity.getScope();
        ensureCapacity.getBody().append(ensureCapacity.getThis().getField(field).invoke("ensureCapacity", Void.TYPE, ensureCapacityScope.getVariable("size")));
        constructor.getBody().append(constructor.getThis().setField(field, ByteCodeExpressions.newInstance(field.getType(), stateField.initialValueExpression())));
        return field;
    }

    private static List<StateField> enumerateFields(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet primitiveClasses = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Long.TYPE, Double.TYPE);
        ImmutableSet supportedClasses = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Long.TYPE, Double.TYPE, Slice.class, Block.class, (Object[])new Class[0]);
        for (Method method : clazz.getMethods()) {
            String name;
            Class<?> type;
            if (method.getName().equals("getEstimatedSize")) continue;
            if (method.getName().startsWith("get")) {
                type = method.getReturnType();
                Preconditions.checkArgument((boolean)supportedClasses.contains(type), (Object)(type.getName() + " is not supported"));
                name = method.getName().substring(3);
                builder.add((Object)new StateField(name, (Class)type, StateCompiler.getInitialValue(method)));
            }
            if (!method.getName().startsWith("is")) continue;
            type = method.getReturnType();
            Preconditions.checkArgument((type == Boolean.TYPE ? 1 : 0) != 0, (Object)"Only boolean is support for 'is' methods");
            name = method.getName().substring(2);
            builder.add((Object)new StateField(name, type, StateCompiler.getInitialValue(method), method.getName()));
        }
        Ordering<StateField> ordering = new Ordering<StateField>((Set)primitiveClasses){
            final /* synthetic */ Set val$primitiveClasses;
            {
                this.val$primitiveClasses = set;
            }

            public int compare(StateField left, StateField right) {
                if (this.val$primitiveClasses.contains(left.getType()) && !this.val$primitiveClasses.contains(right.getType())) {
                    return -1;
                }
                if (this.val$primitiveClasses.contains(right.getType()) && !this.val$primitiveClasses.contains(left.getType())) {
                    return 1;
                }
                return left.getName().compareTo(right.getName());
            }
        };
        List fields = ordering.sortedCopy((Iterable)builder.build());
        StateCompiler.checkInterface(clazz, fields);
        return fields;
    }

    private static Object getInitialValue(Method method) {
        Constable value = null;
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof InitialLongValue) {
                Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object[])new Object[]{method.getName()});
                Preconditions.checkArgument((method.getReturnType() == Long.TYPE ? 1 : 0) != 0, (String)"%s does not return a long, but is annotated with @InitialLongValue", (Object[])new Object[]{method.getName()});
                value = ((InitialLongValue)annotation).value();
                continue;
            }
            if (annotation instanceof InitialDoubleValue) {
                Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object[])new Object[]{method.getName()});
                Preconditions.checkArgument((method.getReturnType() == Double.TYPE ? 1 : 0) != 0, (String)"%s does not return a double, but is annotated with @InitialDoubleValue", (Object[])new Object[]{method.getName()});
                value = ((InitialDoubleValue)annotation).value();
                continue;
            }
            if (!(annotation instanceof InitialBooleanValue)) continue;
            Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object[])new Object[]{method.getName()});
            Preconditions.checkArgument((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)"%s does not return a boolean, but is annotated with @InitialBooleanValue", (Object[])new Object[]{method.getName()});
            value = Boolean.valueOf(((InitialBooleanValue)annotation).value());
        }
        return value;
    }

    private static void checkInterface(Class<?> clazz, List<StateField> fields) {
        Preconditions.checkArgument((boolean)clazz.isInterface(), (Object)(clazz.getName() + " is not an interface"));
        HashSet<String> setters = new HashSet<String>();
        HashSet<String> getters = new HashSet<String>();
        HashSet<String> isGetters = new HashSet<String>();
        HashMap fieldTypes = new HashMap();
        for (StateField field : fields) {
            fieldTypes.put(field.getName(), field.getType());
        }
        for (Method method : clazz.getMethods()) {
            String name;
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (method.getName().equals("getEstimatedSize")) {
                Preconditions.checkArgument((boolean)method.getReturnType().equals(Long.TYPE), (Object)"getEstimatedSize must return long");
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"getEstimatedSize may not have parameters");
                continue;
            }
            if (method.getName().startsWith("get")) {
                name = method.getName().substring(3);
                Preconditions.checkArgument((boolean)((Class)fieldTypes.get(name)).equals(method.getReturnType()), (String)"Expected %s to return type %s, but found %s", (Object[])new Object[]{method.getName(), fieldTypes.get(name), method.getReturnType()});
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Expected %s to have zero parameters", (Object[])new Object[]{method.getName()});
                getters.add(name);
                continue;
            }
            if (method.getName().startsWith("is")) {
                name = method.getName().substring(2);
                Preconditions.checkArgument((fieldTypes.get(name) == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected %s to have type boolean, but found %s", (Object[])new Object[]{name, fieldTypes.get(name)});
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Expected %s to have zero parameters", (Object[])new Object[]{method.getName()});
                Preconditions.checkArgument((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected %s to return boolean", (Object[])new Object[]{method.getName()});
                isGetters.add(name);
                continue;
            }
            if (method.getName().startsWith("set")) {
                name = method.getName().substring(3);
                Preconditions.checkArgument((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (Object)"Expected setter to have one parameter");
                Preconditions.checkArgument((boolean)((Class)fieldTypes.get(name)).equals(method.getParameterTypes()[0]), (String)"Expected %s to accept type %s, but found %s", (Object[])new Object[]{method.getName(), fieldTypes.get(name), method.getParameterTypes()[0]});
                Preconditions.checkArgument((StateCompiler.getInitialValue(method) == null ? 1 : 0) != 0, (Object)"initial value annotation not allowed on setter");
                Preconditions.checkArgument((boolean)method.getReturnType().equals(Void.TYPE), (String)"%s may not return a value", (Object[])new Object[]{method.getName()});
                setters.add(name);
                continue;
            }
            throw new IllegalArgumentException("Cannot generate implementation for method: " + method.getName());
        }
        Preconditions.checkArgument((getters.size() + isGetters.size() == setters.size() && setters.size() == fields.size() ? 1 : 0) != 0, (Object)"Wrong number of getters/setters");
    }

    private static final class StateField {
        private final String name;
        private final String getterName;
        private final Class<?> type;
        private final Object initialValue;

        private StateField(String name, Class<?> type, Object initialValue) {
            this(name, type, initialValue, "get" + name);
        }

        private StateField(String name, Class<?> type, Object initialValue, String getterName) {
            this.name = Objects.requireNonNull(name, "name is null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            this.type = Objects.requireNonNull(type, "type is null");
            this.getterName = Objects.requireNonNull(getterName, "getterName is null");
            this.initialValue = initialValue;
        }

        public String getGetterName() {
            return this.getterName;
        }

        public String getSetterName() {
            return "set" + this.getName();
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public int sizeOfType() {
            if (this.getType() == Long.TYPE) {
                return 8;
            }
            if (this.getType() == Double.TYPE) {
                return 8;
            }
            if (this.getType() == Boolean.TYPE || this.getType() == Byte.TYPE) {
                return 1;
            }
            throw new IllegalArgumentException("Unsupported type: " + this.getType());
        }

        public Object getInitialValue() {
            return this.initialValue;
        }

        public ByteCodeExpression initialValueExpression() {
            if (this.initialValue == null) {
                return ByteCodeExpressions.defaultValue(this.type);
            }
            if (this.initialValue instanceof Number) {
                return ByteCodeExpressions.constantNumber((Number)this.initialValue);
            }
            if (this.initialValue instanceof Boolean) {
                return ByteCodeExpressions.constantBoolean((Boolean)this.initialValue);
            }
            throw new IllegalArgumentException("Unsupported initial value type: " + this.initialValue.getClass());
        }
    }
}

