/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.ParametricAggregation;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.util.Reflection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ChecksumAggregation
extends ParametricAggregation {
    public static final ChecksumAggregation CHECKSUM_AGGREGATION = new ChecksumAggregation();
    @VisibleForTesting
    public static final long PRIME64 = -7046029288634856825L;
    private static final String NAME = "checksum";
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(ChecksumAggregation.class, "output", NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(ChecksumAggregation.class, "input", Type.class, NullableLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(ChecksumAggregation.class, "combine", NullableLongState.class, NullableLongState.class);
    private static final Signature SIGNATURE = new Signature("checksum", FunctionType.AGGREGATE, (List<TypeParameter>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), "varbinary", (List<String>)ImmutableList.of((Object)"T"), false);

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public String getDescription() {
        return "Checksum of the given values";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type valueType = types.get("T");
        Signature signature = new Signature(NAME, FunctionType.AGGREGATE, VarbinaryType.VARBINARY.getTypeSignature(), valueType.getTypeSignature());
        InternalAggregationFunction aggregation = ChecksumAggregation.generateAggregation(valueType);
        return new FunctionInfo(signature, this.getDescription(), aggregation);
    }

    private static InternalAggregationFunction generateAggregation(Type type) {
        DynamicClassLoader classLoader = new DynamicClassLoader(ChecksumAggregation.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, type, (List<Type>)inputTypes), ChecksumAggregation.createInputParameterMetadata(type), INPUT_FUNCTION.bindTo(type), null, null, COMBINE_FUNCTION, OUTPUT_FUNCTION, NullableLongState.class, new StateCompiler().generateStateSerializer(NullableLongState.class, classLoader), new StateCompiler().generateStateFactory(NullableLongState.class, classLoader), (Type)VarbinaryType.VARBINARY, false);
        GenericAccumulatorFactoryBinder factory = new AccumulatorCompiler().generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, (Type)BigintType.BIGINT, (Type)VarbinaryType.VARBINARY, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(Type type, NullableLongState state, Block block, int position) {
        state.setNull(false);
        if (block.isNull(position)) {
            state.setLong(state.getLong() + -7046029288634856825L);
        } else {
            state.setLong(state.getLong() + (long)type.hash(block, position) * -7046029288634856825L);
        }
    }

    public static void combine(NullableLongState state, NullableLongState otherState) {
        state.setNull(state.isNull() && otherState.isNull());
        state.setLong(state.getLong() + otherState.getLong());
    }

    public static void output(NullableLongState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            VarbinaryType.VARBINARY.writeSlice(out, Slices.wrappedLongArray((long[])new long[]{state.getLong()}));
        }
    }
}

