/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.NestedLoopJoinPages;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;

public class NestedLoopJoinPagesBuilder {
    private final TaskContext taskContext;
    private List<Page> pages;
    private boolean finished;
    private long estimatedSize;

    NestedLoopJoinPagesBuilder(TaskContext taskContext) {
        this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
        this.pages = Lists.newArrayList();
    }

    public void addPage(Page page) {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"NestedLoopJoinPagesBuilder is finished");
        if (page.getPositionCount() == 0) {
            return;
        }
        this.pages.add(page);
        this.estimatedSize += page.getRetainedSizeInBytes();
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)this.estimatedSize, DataSize.Unit.BYTE);
    }

    public void compact() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"NestedLoopJoinPagesBuilder is finished");
        this.pages.stream().forEach(Page::compact);
        this.estimatedSize = this.pages.stream().mapToLong(Page::getRetainedSizeInBytes).sum();
    }

    public NestedLoopJoinPages build() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"NestedLoopJoinPagesBuilder is already finished");
        this.finished = true;
        this.pages = ImmutableList.copyOf(this.pages);
        return new NestedLoopJoinPages(this.pages, this.getEstimatedSize(), this.taskContext);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("estimatedSize", this.estimatedSize).add("pageCount", this.pages.size()).toString();
    }
}

