/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.SettableLookupSourceSupplier;
import com.facebook.presto.operator.SharedLookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class HashBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final SettableLookupSourceSupplier lookupSourceSupplier;
    private final List<Integer> hashChannels;
    private final Optional<Integer> hashChannel;
    private final PagesIndex pagesIndex;
    private boolean finished;

    public HashBuilderOperator(OperatorContext operatorContext, SettableLookupSourceSupplier lookupSourceSupplier, List<Integer> hashChannels, Optional<Integer> hashChannel, int expectedPositions) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.lookupSourceSupplier = Objects.requireNonNull(lookupSourceSupplier, "hashSupplier is null");
        Preconditions.checkArgument((!hashChannels.isEmpty() ? 1 : 0) != 0, (Object)"hashChannels is empty");
        this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.pagesIndex = new PagesIndex(lookupSourceSupplier.getTypes(), expectedPositions);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.lookupSourceSupplier.getTypes();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.operatorContext.setMemoryReservation(0L);
        this.lookupSourceSupplier.setLookupSource(new SharedLookupSource(this.pagesIndex.createLookupSource(this.hashChannels, this.hashChannel), this.operatorContext.getDriverContext().getPipelineContext().getTaskContext()));
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.pagesIndex.addPage(page);
        if (!this.operatorContext.trySetMemoryReservation(this.pagesIndex.getEstimatedSize().toBytes())) {
            this.pagesIndex.compact();
        }
        this.operatorContext.setMemoryReservation(this.pagesIndex.getEstimatedSize().toBytes());
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class HashBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final SettableLookupSourceSupplier lookupSourceSupplier;
        private final List<Integer> hashChannels;
        private final Optional<Integer> hashChannel;
        private final int expectedPositions;
        private boolean closed;

        public HashBuilderOperatorFactory(int operatorId, List<Type> types, List<Integer> hashChannels, Optional<Integer> hashChannel, int expectedPositions) {
            this.operatorId = operatorId;
            this.lookupSourceSupplier = new SettableLookupSourceSupplier(Objects.requireNonNull(types, "types is null"));
            Preconditions.checkArgument((!hashChannels.isEmpty() ? 1 : 0) != 0, (Object)"hashChannels is empty");
            this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.expectedPositions = expectedPositions;
        }

        public LookupSourceSupplier getLookupSourceSupplier() {
            return this.lookupSourceSupplier;
        }

        @Override
        public List<Type> getTypes() {
            return this.lookupSourceSupplier.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashBuilderOperator.class.getSimpleName());
            return new HashBuilderOperator(operatorContext, this.lookupSourceSupplier, this.hashChannels, this.hashChannel, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

