/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TablePropertyManager {
    private final ConcurrentMap<String, Map<String, PropertyMetadata<?>>> catalogTableProperties = new ConcurrentHashMap();

    public void addTableProperties(String catalog, List<PropertyMetadata<?>> tableProperties) {
        Objects.requireNonNull(catalog, "catalog is null");
        Preconditions.checkArgument((!catalog.isEmpty() && catalog.trim().equals(catalog) ? 1 : 0) != 0, (String)"Invalid catalog name '%s'", (Object[])new Object[]{catalog});
        Objects.requireNonNull(tableProperties, "tableProperties is null");
        ImmutableMap propertiesByName = Maps.uniqueIndex(tableProperties, PropertyMetadata::getName);
        Preconditions.checkState((this.catalogTableProperties.putIfAbsent(catalog, (Map<String, PropertyMetadata<?>>)propertiesByName) == null ? 1 : 0) != 0, (String)"TableProperties for catalog '%s' are already registered", (Object[])new Object[]{catalog});
    }

    public Map<String, Object> getTableProperties(String catalog, Map<String, Expression> sqlPropertyValues, Session session, Metadata metadata) {
        Map tableProperties = (Map)this.catalogTableProperties.get(catalog);
        if (tableProperties == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog not found: " + catalog);
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        for (PropertyMetadata tableProperty : tableProperties.values()) {
            Object value;
            Expression expression = sqlPropertyValues.get(tableProperty.getName());
            if (expression != null) {
                Object sqlObjectValue = SessionPropertyManager.evaluatePropertyValue(expression, tableProperty.getSqlType(), session, metadata);
                value = tableProperty.decode(sqlObjectValue);
            } else {
                value = tableProperty.getDefaultValue();
            }
            if (value == null) continue;
            properties.put((Object)tableProperty.getName(), value);
        }
        return properties.build();
    }

    public Map<String, Map<String, PropertyMetadata<?>>> getAllTableProperties() {
        return ImmutableMap.copyOf(this.catalogTableProperties);
    }
}

