/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.FunctionType;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class ParametricOperator
implements ParametricFunction {
    private final OperatorType operatorType;
    private final List<TypeParameter> typeParameters;
    private final String returnType;
    private final List<String> argumentTypes;

    protected ParametricOperator(OperatorType operatorType, List<TypeParameter> typeParameters, String returnType, List<String> argumentTypes) {
        this.typeParameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(typeParameters, "typeParameters is null"));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
    }

    @Override
    public Signature getSignature() {
        return new Signature(FunctionRegistry.mangleOperatorName(this.operatorType), FunctionType.SCALAR, this.typeParameters, this.returnType, this.argumentTypes, false);
    }

    @Override
    public final boolean isHidden() {
        return true;
    }

    @Override
    public final boolean isDeterministic() {
        return true;
    }

    @Override
    public final String getDescription() {
        return null;
    }
}

