/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.RemoteTask;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class ScheduleResult {
    private final Set<RemoteTask> newTasks;
    private final CompletableFuture<?> blocked;
    private final boolean finished;

    public ScheduleResult(boolean finished, Iterable<? extends RemoteTask> newTasks, CompletableFuture<?> blocked) {
        this.finished = finished;
        this.newTasks = ImmutableSet.copyOf(Objects.requireNonNull(newTasks, "newTasks is null"));
        this.blocked = Objects.requireNonNull(blocked, "blocked is null");
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Set<RemoteTask> getNewTasks() {
        return this.newTasks;
    }

    public CompletableFuture<?> getBlocked() {
        return this.blocked;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("finished", this.finished).add("newTasks", this.newTasks.size()).add("blocked", this.blocked.isDone()).toString();
    }
}

