/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.OutputBufferManager;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PartitionedOutputBufferManager
implements OutputBufferManager {
    protected final Consumer<OutputBuffers> outputBufferTarget;
    protected final BiFunction<Integer, Integer, PagePartitionFunction> partitionFunctionGenerator;
    @GuardedBy(value="this")
    private final Set<TaskId> bufferIds = new LinkedHashSet<TaskId>();
    @GuardedBy(value="this")
    private boolean noMoreBufferIds;

    public PartitionedOutputBufferManager(Consumer<OutputBuffers> outputBufferTarget, BiFunction<Integer, Integer, PagePartitionFunction> partitionFunctionGenerator) {
        this.outputBufferTarget = Objects.requireNonNull(outputBufferTarget, "outputBufferTarget is null");
        this.partitionFunctionGenerator = Objects.requireNonNull(partitionFunctionGenerator, "partitionFunctionGenerator is null");
    }

    @Override
    public synchronized void addOutputBuffer(TaskId bufferId) {
        if (this.noMoreBufferIds) {
            return;
        }
        this.bufferIds.add(bufferId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noMoreOutputBuffers() {
        OutputBuffers outputBuffers;
        PartitionedOutputBufferManager partitionedOutputBufferManager = this;
        synchronized (partitionedOutputBufferManager) {
            if (this.noMoreBufferIds) {
                return;
            }
            this.noMoreBufferIds = true;
            ImmutableMap.Builder buffers = ImmutableMap.builder();
            int partition = 0;
            int partitionCount = this.bufferIds.size();
            for (TaskId bufferId : this.bufferIds) {
                buffers.put((Object)bufferId, (Object)this.partitionFunctionGenerator.apply(partition, partitionCount));
                ++partition;
            }
            outputBuffers = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffers((Map<TaskId, PagePartitionFunction>)buffers.build()).withNoMoreBufferIds();
        }
        this.outputBufferTarget.accept(outputBuffers);
    }
}

