/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.NodeScheduler;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.scheduler.ScheduleResult;
import com.facebook.presto.execution.scheduler.StageScheduler;
import com.facebook.presto.spi.Node;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public class CurrentNodeScheduler
implements StageScheduler {
    private final Function<Node, RemoteTask> taskScheduler;
    private final Supplier<Node> currentNodeSupplier;

    public CurrentNodeScheduler(SqlStageExecution stage, NodeScheduler.NodeSelector nodeSelector) {
        this(Objects.requireNonNull(stage, "stage is null")::scheduleTask, Objects.requireNonNull(nodeSelector, "nodeSelector is null")::selectCurrentNode);
    }

    public CurrentNodeScheduler(Function<Node, RemoteTask> taskScheduler, Supplier<Node> currentNodeSupplier) {
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "taskScheduler is null");
        this.currentNodeSupplier = Objects.requireNonNull(currentNodeSupplier, "currentNodeSupplier is null");
    }

    @Override
    public ScheduleResult schedule() {
        RemoteTask task = this.taskScheduler.apply(this.currentNodeSupplier.get());
        return new ScheduleResult(true, (Iterable<? extends RemoteTask>)ImmutableList.of((Object)task), CompletableFuture.completedFuture(null));
    }
}

