/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.spi.Node;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NodeTaskMap {
    private final ConcurrentHashMap<Node, NodeTasks> nodeTasksMap = new ConcurrentHashMap();

    public void addTask(Node node, RemoteTask task) {
        this.createOrGetNodeTasks(node).addTask(task);
    }

    public int getPartitionedSplitsOnNode(Node node) {
        return this.createOrGetNodeTasks(node).getPartitionedSplitCount();
    }

    public SplitCountChangeListener getSplitCountChangeListener(Node node) {
        return this.createOrGetNodeTasks(node).getSplitCountChangeListener();
    }

    private NodeTasks createOrGetNodeTasks(Node node) {
        NodeTasks nodeTasks = this.nodeTasksMap.get(node);
        if (nodeTasks == null) {
            nodeTasks = this.addNodeTask(node);
        }
        return nodeTasks;
    }

    private NodeTasks addNodeTask(Node node) {
        NodeTasks newNodeTasks = new NodeTasks();
        NodeTasks nodeTasks = this.nodeTasksMap.putIfAbsent(node, newNodeTasks);
        if (nodeTasks == null) {
            return newNodeTasks;
        }
        return nodeTasks;
    }

    public static interface SplitCountChangeListener {
        public void splitCountChanged(int var1);
    }

    private static class NodeTasks {
        private final Set<RemoteTask> remoteTasks = Sets.newConcurrentHashSet();
        private final AtomicInteger partitionedSplitCount = new AtomicInteger();
        private final SplitCountChangeListener splitCountChangeListener = this.partitionedSplitCount::addAndGet;

        private NodeTasks() {
        }

        private int getPartitionedSplitCount() {
            return this.partitionedSplitCount.get();
        }

        private void addTask(RemoteTask task) {
            if (this.remoteTasks.add(task)) {
                task.addStateChangeListener(taskInfo -> {
                    if (task.getTaskInfo().getState().isDone()) {
                        this.remoteTasks.remove(task);
                    }
                });
                if (task.getTaskInfo().getState().isDone()) {
                    this.remoteTasks.remove(task);
                }
            }
        }

        public SplitCountChangeListener getSplitCountChangeListener() {
            return this.splitCountChangeListener;
        }
    }
}

