/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.ImmutableCollectors;
import io.airlift.json.JsonCodec;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateViewTask
implements DataDefinitionTask<CreateView> {
    private final JsonCodec<ViewDefinition> codec;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final boolean experimentalSyntaxEnabled;

    @Inject
    public CreateViewTask(JsonCodec<ViewDefinition> codec, SqlParser sqlParser, AccessControl accessControl, FeaturesConfig featuresConfig) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.experimentalSyntaxEnabled = featuresConfig.isExperimentalSyntaxEnabled();
    }

    @Override
    public String getName() {
        return "CREATE VIEW";
    }

    @Override
    public String explain(CreateView statement) {
        return "CREATE VIEW " + statement.getName();
    }

    @Override
    public void execute(CreateView statement, Session session, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine) {
        QualifiedTableName name = MetadataUtil.createQualifiedTableName(session, (Node)statement, statement.getName());
        accessControl.checkCanCreateView(session.getIdentity(), name);
        String sql = this.getFormattedSql(statement);
        Analysis analysis = this.analyzeStatement((Statement)statement, session, metadata);
        List columns = (List)analysis.getOutputDescriptor().getVisibleFields().stream().map(field -> new ViewDefinition.ViewColumn(field.getName().get(), field.getType())).collect(ImmutableCollectors.toImmutableList());
        String data = this.codec.toJson((Object)new ViewDefinition(sql, session.getCatalog(), session.getSchema(), columns, Optional.of(session.getUser())));
        metadata.createView(session, name, data, statement.isReplace());
    }

    private Analysis analyzeStatement(Statement statement, Session session, Metadata metadata) {
        Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, this.accessControl, Optional.empty(), this.experimentalSyntaxEnabled);
        return analyzer.analyze(statement);
    }

    private String getFormattedSql(CreateView statement) {
        Statement parsed;
        Query query = statement.getQuery();
        String sql = SqlFormatter.formatSql((Node)query);
        try {
            parsed = this.sqlParser.createStatement(sql);
        }
        catch (ParsingException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Formatted query does not parse: " + query);
        }
        if (!query.equals((Object)parsed)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Query does not round-trip: " + query);
        }
        return sql;
    }
}

