/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemColumnHandle;
import com.facebook.presto.connector.system.SystemSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SystemRecordSetProvider
implements ConnectorRecordSetProvider {
    private final Map<SchemaTableName, SystemTable> tables;

    public SystemRecordSetProvider(Set<SystemTable> tables) {
        this.tables = Maps.uniqueIndex(tables, table -> table.getTableMetadata().getTable());
    }

    public RecordSet getRecordSet(ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(columns, "columns is null");
        SystemSplit systemSplit = Types.checkType(split, SystemSplit.class, "split");
        SchemaTableName tableName = systemSplit.getTableHandle().getSchemaTableName();
        SystemTable systemTable = this.tables.get(tableName);
        Preconditions.checkArgument((systemTable != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        List tableColumns = systemTable.getTableMetadata().getColumns();
        HashMap<String, Integer> columnsByName = new HashMap<String, Integer>();
        for (int i = 0; i < tableColumns.size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableColumns.get(i);
            if (columnsByName.put(column.getName(), i) == null) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "Duplicate column name: " + column.getName());
        }
        ImmutableList.Builder userToSystemFieldIndex = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            String columnName = Types.checkType(columnHandle, SystemColumnHandle.class, "column").getColumnName();
            Integer n = (Integer)columnsByName.get(columnName);
            if (n == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, String.format("Column does not exist: %s.%s", tableName, columnName));
            }
            userToSystemFieldIndex.add((Object)n);
        }
        TupleDomain<ColumnHandle> constraint = systemSplit.getConstraint();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : constraint.getDomains().entrySet()) {
            String columnName = Types.checkType(entry.getKey(), SystemColumnHandle.class, "column").getColumnName();
            builder.put(columnsByName.get(columnName), entry.getValue());
        }
        TupleDomain newContraint = TupleDomain.withColumnDomains((Map)builder.build());
        return new MappedRecordSet(SystemRecordSetProvider.toRecordSet(systemTable, session, (TupleDomain<Integer>)newContraint), (List<Integer>)userToSystemFieldIndex.build());
    }

    private static RecordSet toRecordSet(final SystemTable table, final ConnectorSession session, final TupleDomain<Integer> constraint) {
        return new RecordSet(){
            private final List<Type> types;
            {
                this.types = (List)table.getTableMetadata().getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableCollectors.toImmutableList());
            }

            public List<Type> getColumnTypes() {
                return this.types;
            }

            public RecordCursor cursor() {
                return table.cursor(session, constraint);
            }
        };
    }
}

