/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeBlock;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.MethodGenerationContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ConstantByteCodeExpression;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

class InvokeDynamicByteCodeExpression
extends ByteCodeExpression {
    private final Method bootstrapMethod;
    private final List<Object> bootstrapArgs;
    private final String methodName;
    private final ParameterizedType returnType;
    private final List<ByteCodeExpression> parameters;
    private final List<ParameterizedType> parameterTypes;

    InvokeDynamicByteCodeExpression(Method bootstrapMethod, Iterable<?> bootstrapArgs, String methodName, ParameterizedType returnType, Iterable<? extends ByteCodeExpression> parameters, Iterable<ParameterizedType> parameterTypes) {
        super(returnType);
        this.bootstrapMethod = Objects.requireNonNull(bootstrapMethod, "bootstrapMethod is null");
        this.bootstrapArgs = ImmutableList.copyOf(Objects.requireNonNull(bootstrapArgs, "bootstrapArgs is null"));
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.parameters = ImmutableList.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.parameterTypes = ImmutableList.copyOf(Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
    }

    @Override
    public ByteCodeNode getByteCode(MethodGenerationContext generationContext) {
        ByteCodeBlock block = new ByteCodeBlock();
        for (ByteCodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        return block.invokeDynamic(this.methodName, this.returnType, this.parameterTypes, this.bootstrapMethod, this.bootstrapArgs);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    protected String formatOneLine() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.bootstrapMethod.getName());
        if (!this.bootstrapArgs.isEmpty()) {
            builder.append("(").append(Joiner.on((String)", ").join(Iterables.transform(this.bootstrapArgs, ConstantByteCodeExpression::renderConstant))).append(")");
        }
        builder.append("]=>");
        builder.append(this.methodName).append("(").append(Joiner.on((String)", ").join(this.parameters)).append(")");
        return builder.toString();
    }
}

