/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static void appendObject(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (type.getJavaType() == Slice.class) {
            Slice slice = value instanceof byte[] ? Slices.wrappedBuffer((byte[])((byte[])value)) : (value instanceof String ? Slices.utf8Slice((String)((String)value)) : (Slice)value);
            type.writeSlice(blockBuilder, slice, 0, slice.length());
        } else {
            type.writeObject(blockBuilder, value);
        }
    }
}

