/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class SessionRepresentation {
    private final String user;
    private final Optional<String> principal;
    private final Optional<String> source;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final TimeZoneKey timeZoneKey;
    private final Locale locale;
    private final Optional<String> remoteUserAddress;
    private final Optional<String> userAgent;
    private final long startTime;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogProperties;

    @JsonCreator
    public SessionRepresentation(@JsonProperty(value="user") String user, @JsonProperty(value="principal") Optional<String> principal, @JsonProperty(value="source") Optional<String> source, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="timeZoneKey") TimeZoneKey timeZoneKey, @JsonProperty(value="locale") Locale locale, @JsonProperty(value="remoteUserAddress") Optional<String> remoteUserAddress, @JsonProperty(value="userAgent") Optional<String> userAgent, @JsonProperty(value="startTime") long startTime, @JsonProperty(value="systemProperties") Map<String, String> systemProperties, @JsonProperty(value="catalogProperties") Map<String, Map<String, String>> catalogProperties) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.locale = Objects.requireNonNull(locale, "locale is null");
        this.remoteUserAddress = Objects.requireNonNull(remoteUserAddress, "remoteUserAddress is null");
        this.userAgent = Objects.requireNonNull(userAgent, "userAgent is null");
        this.startTime = startTime;
        this.systemProperties = ImmutableMap.copyOf(systemProperties);
        ImmutableMap.Builder catalogPropertiesBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, String>> entry : catalogProperties.entrySet()) {
            catalogPropertiesBuilder.put((Object)entry.getKey(), (Object)ImmutableMap.copyOf(entry.getValue()));
        }
        this.catalogProperties = catalogPropertiesBuilder.build();
    }

    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    public Optional<String> getPrincipal() {
        return this.principal;
    }

    @JsonProperty
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @JsonProperty
    public Locale getLocale() {
        return this.locale;
    }

    @JsonProperty
    public Optional<String> getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    @JsonProperty
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty
    public long getStartTime() {
        return this.startTime;
    }

    @JsonProperty
    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    @JsonProperty
    public Map<String, Map<String, String>> getCatalogProperties() {
        return this.catalogProperties;
    }

    public Session toSession(SessionPropertyManager sessionPropertyManager) {
        return new Session(new Identity(this.user, Optional.empty()), this.source, this.catalog, this.schema, this.timeZoneKey, this.locale, this.remoteUserAddress, this.userAgent, this.startTime, this.systemProperties, this.catalogProperties, sessionPropertyManager);
    }
}

