/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.Session;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.execution.SimpleDomain;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Domain;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.util.QueryExplanation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class JsonPlanPrinter {
    private static final JsonCodec<QueryExplanation> CODEC = JsonCodec.jsonCodec(QueryExplanation.class);
    private final ImmutableList.Builder<Input> inputBuilder = ImmutableList.builder();

    private JsonPlanPrinter(PlanNode plan, Metadata metadata, Session session) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        SourceVisitor visitor = new SourceVisitor(metadata, session);
        plan.accept(visitor, null);
    }

    public static String getPlan(PlanNode plan, Metadata metadata, Session session) {
        return new JsonPlanPrinter(plan, metadata, session).toString();
    }

    public String toString() {
        return CODEC.toJson((Object)new QueryExplanation((List<Input>)this.inputBuilder.build()));
    }

    private class SourceVisitor
    extends PlanVisitor<Void, Void> {
        private final Metadata metadata;
        private final Session session;

        public SourceVisitor(Metadata metadata, Session session) {
            this.session = session;
            this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata);
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getLeft().accept(this, null);
            node.getRight().accept(this, null);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            node.getSource().accept(this, null);
            node.getFilteringSource().accept(this, null);
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            node.getProbeSource().accept(this, null);
            node.getIndexSource().accept(this, null);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, node.getTable());
            ImmutableList.Builder columnBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(this.session, node.getTable(), entry.getValue());
                TupleDomain<ColumnHandle> constraint = node.getCurrentConstraint();
                Domain domain = null;
                if (constraint.isNone()) {
                    domain = Domain.none((Class)columnMetadata.getType().getJavaType());
                } else if (constraint.getDomains().containsKey(entry.getValue())) {
                    domain = (Domain)constraint.getDomains().get(entry.getValue());
                }
                Column column = new Column(columnMetadata.getName(), columnMetadata.getType().toString(), Optional.empty());
                Optional.ofNullable(SimpleDomain.fromDomain(domain));
                columnBuilder.add((Object)column);
            }
            Input input = new Input(tableMetadata.getConnectorId(), tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), (List<Column>)columnBuilder.build());
            JsonPlanPrinter.this.inputBuilder.add((Object)input);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, node.getTableHandle());
            ImmutableList.Builder columnBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(this.session, node.getTableHandle(), entry.getValue());
                Domain domain = null;
                if (!node.getEffectiveTupleDomain().isNone() && node.getEffectiveTupleDomain().getDomains().containsKey(entry.getValue())) {
                    domain = (Domain)node.getEffectiveTupleDomain().getDomains().get(entry.getValue());
                } else if (node.getEffectiveTupleDomain().isNone()) {
                    domain = Domain.none((Class)columnMetadata.getType().getJavaType());
                }
                Column column = new Column(columnMetadata.getName(), columnMetadata.getType().toString(), Optional.ofNullable(SimpleDomain.fromDomain(domain)));
                columnBuilder.add((Object)column);
            }
            Input input = new Input(tableMetadata.getConnectorId(), tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), (List<Column>)columnBuilder.build());
            JsonPlanPrinter.this.inputBuilder.add((Object)input);
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitOutput(OutputNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTopN(TopNNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Void context) {
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        public Void visitTableCommit(TableCommitNode node, Void context) {
            return this.processChildren(node);
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, null);
            }
            return null;
        }
    }
}

