/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public final class VarcharOperators {
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapperProvider().get().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    private VarcharOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="varchar") Slice left, @SqlType(value="varchar") Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="varchar") Slice left, @SqlType(value="varchar") Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="varchar") Slice left, @SqlType(value="varchar") Slice right) {
        return left.compareTo(right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="varchar") Slice left, @SqlType(value="varchar") Slice right) {
        return left.compareTo(right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="varchar") Slice left, @SqlType(value="varchar") Slice right) {
        return left.compareTo(right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="varchar") Slice left, @SqlType(value="varchar") Slice right) {
        return left.compareTo(right) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="varchar") Slice value, @SqlType(value="varchar") Slice min, @SqlType(value="varchar") Slice max) {
        return min.compareTo(value) <= 0 && value.compareTo(max) <= 0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="varchar") Slice value) {
        if (value.length() == 1) {
            byte character = VarcharOperators.toUpperCase(value.getByte(0));
            if (character == 84 || character == 49) {
                return true;
            }
            if (character == 70 || character == 48) {
                return false;
            }
        }
        if (value.length() == 4 && VarcharOperators.toUpperCase(value.getByte(0)) == 84 && VarcharOperators.toUpperCase(value.getByte(1)) == 82 && VarcharOperators.toUpperCase(value.getByte(2)) == 85 && VarcharOperators.toUpperCase(value.getByte(3)) == 69) {
            return true;
        }
        if (value.length() == 5 && VarcharOperators.toUpperCase(value.getByte(0)) == 70 && VarcharOperators.toUpperCase(value.getByte(1)) == 65 && VarcharOperators.toUpperCase(value.getByte(2)) == 76 && VarcharOperators.toUpperCase(value.getByte(3)) == 83 && VarcharOperators.toUpperCase(value.getByte(4)) == 69) {
            return false;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to BOOLEAN", value.toString(StandardCharsets.UTF_8)));
    }

    private static byte toUpperCase(byte b) {
        return VarcharOperators.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte b) {
        return b >= 97 && b <= 122;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="varchar") Slice slice) {
        try {
            return Double.parseDouble(slice.toString(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Can not cast '%s' to DOUBLE", slice.toString(StandardCharsets.UTF_8)));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="varchar") Slice slice) {
        try {
            return Long.parseLong(slice.toString(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Can not cast '%s' to BIGINT", slice.toString(StandardCharsets.UTF_8)));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varbinary")
    public static Slice castToBinary(@SqlType(value="varchar") Slice slice) {
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castToJson(@SqlType(value="varchar") Slice slice) throws IOException {
        try {
            byte[] in = slice.getBytes();
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(in.length);
            SORTED_MAPPER.writeValue((OutputStream)dynamicSliceOutput, SORTED_MAPPER.readValue(in, Object.class));
            return dynamicSliceOutput.slice();
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to JSON", slice.toStringUtf8()));
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="varchar") Slice value) {
        return value.hashCode();
    }
}

