/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class TypeUtils {
    public static final int EXPECTED_ARRAY_SIZE = 1024;
    public static final int NULL_HASH_CODE = 0;

    private TypeUtils() {
    }

    public static int expectedValueSize(Type type, int defaultSize) {
        if (type instanceof FixedWidthType) {
            return ((FixedWidthType)type).getFixedSize();
        }
        return defaultSize;
    }

    public static int hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        return type.hash(block, position);
    }

    public static long hashPosition(MethodHandle methodHandle, Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0L;
        }
        try {
            if (type.getJavaType() == Boolean.TYPE) {
                return methodHandle.invoke(type.getBoolean(block, position));
            }
            if (type.getJavaType() == Long.TYPE) {
                return methodHandle.invoke(type.getLong(block, position));
            }
            if (type.getJavaType() == Double.TYPE) {
                return methodHandle.invoke(type.getDouble(block, position));
            }
            if (type.getJavaType() == Slice.class) {
                return methodHandle.invoke(type.getSlice(block, position));
            }
            throw new UnsupportedOperationException("Unsupported native container type: " + type.getJavaType() + " with type " + type.getTypeSignature());
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public static boolean positionEqualsPosition(Type type, Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftIsNull = leftBlock.isNull(leftPosition);
        boolean rightIsNull = rightBlock.isNull(rightPosition);
        if (leftIsNull || rightIsNull) {
            return leftIsNull && rightIsNull;
        }
        return type.equalTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    public static List<Type> resolveTypes(List<TypeSignature> typeNames, TypeManager typeManager) {
        return (List)typeNames.stream().map(type -> (Type)Preconditions.checkNotNull((Object)typeManager.getType(type), (String)"Type '%s' not found", (Object[])new Object[]{type})).collect(ImmutableCollectors.toImmutableList());
    }

    public static TypeSignature parameterizedTypeName(String base, TypeSignature ... argumentNames) {
        return new TypeSignature(base, (List)ImmutableList.copyOf((Object[])argumentNames), (List)ImmutableList.of());
    }

    public static int getHashPosition(List<? extends Type> hashTypes, Block[] hashBlocks, int position) {
        int[] hashChannels = new int[hashBlocks.length];
        for (int i = 0; i < hashBlocks.length; ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        Page page = new Page(hashBlocks);
        return hashGenerator.hashPosition(position, page);
    }

    public static Block getHashBlock(List<? extends Type> hashTypes, Block ... hashBlocks) {
        Preconditions.checkArgument((hashTypes.size() == hashBlocks.length ? 1 : 0) != 0);
        int[] hashChannels = new int[hashBlocks.length];
        for (int i = 0; i < hashBlocks.length; ++i) {
            hashChannels[i] = i;
        }
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator((List<Type>)ImmutableList.copyOf(hashTypes), hashChannels);
        int positionCount = hashBlocks[0].getPositionCount();
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        Page page = new Page(hashBlocks);
        for (int i = 0; i < positionCount; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)hashGenerator.hashPosition(i, page));
        }
        return builder.build();
    }

    public static Page getHashPage(Page page, List<? extends Type> types, List<Integer> hashChannels) {
        Block[] blocks = Arrays.copyOf(page.getBlocks(), page.getChannelCount() + 1);
        ImmutableList.Builder hashTypes = ImmutableList.builder();
        Block[] hashBlocks = new Block[hashChannels.size()];
        int hashBlockIndex = 0;
        for (int channel : hashChannels) {
            hashTypes.add((Object)types.get(channel));
            hashBlocks[hashBlockIndex++] = blocks[channel];
        }
        blocks[page.getChannelCount()] = TypeUtils.getHashBlock((List<? extends Type>)hashTypes.build(), hashBlocks);
        return new Page(blocks);
    }

    public static Block createBlock(Type type, Object element) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1, 1024);
        TypeUtils.appendToBlockBuilder(type, element, blockBuilder);
        return blockBuilder.build();
    }

    public static void appendToBlockBuilder(Type type, Object element, BlockBuilder blockBuilder) {
        Class javaType = type.getJavaType();
        if (element == null) {
            blockBuilder.appendNull();
        } else if (type.getTypeSignature().getBase().equals("array") && element instanceof Iterable) {
            BlockBuilder subBlockBuilder = ((ArrayType)type).getElementType().createBlockBuilder(new BlockBuilderStatus(), 1024);
            for (Object subElement : (Iterable)element) {
                TypeUtils.appendToBlockBuilder((Type)type.getTypeParameters().get(0), subElement, subBlockBuilder);
            }
            type.writeObject(blockBuilder, (Object)subBlockBuilder);
        } else if (type.getTypeSignature().getBase().equals("row") && element instanceof Iterable) {
            VariableWidthBlockBuilder subBlockBuilder = new VariableWidthBlockBuilder(new BlockBuilderStatus(), 1024);
            int field = 0;
            for (Object subElement : (Iterable)element) {
                TypeUtils.appendToBlockBuilder((Type)type.getTypeParameters().get(field), subElement, (BlockBuilder)subBlockBuilder);
                ++field;
            }
            type.writeObject(blockBuilder, (Object)subBlockBuilder);
        } else if (type.getTypeSignature().getBase().equals("map") && element instanceof Map) {
            VariableWidthBlockBuilder subBlockBuilder = new VariableWidthBlockBuilder(new BlockBuilderStatus(), 1024);
            for (Map.Entry entry : ((Map)element).entrySet()) {
                TypeUtils.appendToBlockBuilder((Type)type.getTypeParameters().get(0), entry.getKey(), (BlockBuilder)subBlockBuilder);
                TypeUtils.appendToBlockBuilder((Type)type.getTypeParameters().get(1), entry.getValue(), (BlockBuilder)subBlockBuilder);
            }
            type.writeObject(blockBuilder, (Object)subBlockBuilder);
        } else if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)element).booleanValue());
        } else if (javaType == Long.TYPE) {
            type.writeLong(blockBuilder, ((Number)element).longValue());
        } else if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)element).doubleValue());
        } else if (javaType == Slice.class) {
            if (element instanceof String) {
                type.writeSlice(blockBuilder, Slices.utf8Slice((String)element.toString()));
            } else if (element instanceof byte[]) {
                type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((byte[])element)));
            } else {
                type.writeSlice(blockBuilder, (Slice)element);
            }
        } else {
            type.writeObject(blockBuilder, element);
        }
    }

    public static Object castValue(Type type, Block block, int position) {
        Class javaType = type.getJavaType();
        if (block.isNull(position)) {
            return null;
        }
        if (javaType == Boolean.TYPE) {
            return type.getBoolean(block, position);
        }
        if (javaType == Long.TYPE) {
            return type.getLong(block, position);
        }
        if (javaType == Double.TYPE) {
            return type.getDouble(block, position);
        }
        if (type.getJavaType() == Slice.class) {
            return type.getSlice(block, position);
        }
        return type.getObject(block, position);
    }

    public static void checkElementNotNull(boolean isNull, String errorMsg) {
        if (isNull) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, errorMsg);
        }
    }
}

