/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.Session;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.MemoryPoolId;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.util.Threads;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import java.util.concurrent.Executor;

public final class TestingTaskContext {
    private TestingTaskContext() {
    }

    public static TaskContext createTaskContext(Executor executor, Session session) {
        return TestingTaskContext.createTaskContext(Threads.checkNotSameThreadExecutor(executor, "executor is null"), session, new DataSize(256.0, DataSize.Unit.MEGABYTE));
    }

    public static TaskContext createTaskContext(Executor executor, Session session, DataSize maxMemory) {
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE), false);
        MemoryPool systemMemoryPool = new MemoryPool(new MemoryPoolId("testSystem"), new DataSize(1.0, DataSize.Unit.GIGABYTE), false);
        QueryContext queryContext = new QueryContext(false, new DataSize(10.0, DataSize.Unit.MEGABYTE), memoryPool, systemMemoryPool, executor);
        return TestingTaskContext.createTaskContext(queryContext, executor, session, maxMemory, new DataSize(1.0, DataSize.Unit.MEGABYTE));
    }

    public static TaskContext createTaskContext(QueryContext queryContext, Executor executor, Session session, DataSize maxMemory, DataSize preallocated) {
        return queryContext.addTaskContext(new TaskStateMachine(new TaskId("query", "stage", "task"), Threads.checkNotSameThreadExecutor(executor, "executor is null")), session, (DataSize)Preconditions.checkNotNull((Object)maxMemory, (Object)"maxMemory is null"), preallocated, true, true);
    }
}

