/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.testing.RunLengthEncodedBlock;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class RunLengthBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<RunLengthBlockEncoding> FACTORY = new RunLengthBlockEncodingFactory();
    private static final String NAME = "RLE";
    private final BlockEncoding valueBlockEncoding;

    public RunLengthBlockEncoding(BlockEncoding valueBlockEncoding) {
        this.valueBlockEncoding = (BlockEncoding)Preconditions.checkNotNull((Object)valueBlockEncoding, (Object)"valueBlockEncoding is null");
    }

    public String getName() {
        return NAME;
    }

    public BlockEncoding getValueBlockEncoding() {
        return this.valueBlockEncoding;
    }

    public void writeBlock(SliceOutput sliceOutput, Block block) {
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block;
        sliceOutput.writeInt(rleBlock.getPositionCount());
        this.getValueBlockEncoding().writeBlock(sliceOutput, rleBlock.getValue());
    }

    public int getEstimatedSize(Block block) {
        RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)block;
        return 4 + this.getValueBlockEncoding().getEstimatedSize(rleBlock.getValue());
    }

    public RunLengthEncodedBlock readBlock(SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        Block value = this.getValueBlockEncoding().readBlock(sliceInput);
        return new RunLengthEncodedBlock(value, positionCount);
    }

    public BlockEncodingFactory getFactory() {
        return FACTORY;
    }

    private static class RunLengthBlockEncodingFactory
    implements BlockEncodingFactory<RunLengthBlockEncoding> {
        private RunLengthBlockEncodingFactory() {
        }

        public String getName() {
            return RunLengthBlockEncoding.NAME;
        }

        public RunLengthBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            BlockEncoding valueBlockEncoding = serde.readBlockEncoding(input);
            return new RunLengthBlockEncoding(valueBlockEncoding);
        }

        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, RunLengthBlockEncoding blockEncoding) {
            serde.writeBlockEncoding(output, blockEncoding.getValueBlockEncoding());
        }
    }
}

