/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class MaterializedRow {
    private final int precision;
    private final List<Object> values;

    public MaterializedRow(int precision, Object ... values) {
        this(precision, Arrays.asList((Object[])Preconditions.checkNotNull((Object)values, (Object)"values is null")));
    }

    public MaterializedRow(int precision, List<Object> values) {
        Preconditions.checkArgument((precision > 0 ? 1 : 0) != 0, (Object)"Need at least one digit of precision");
        this.precision = precision;
        this.values = new ArrayList<Object>(values.size());
        for (Object object : values) {
            if (object instanceof Double || object instanceof Float) {
                this.values.add(new ApproximateDouble(((Number)object).doubleValue(), precision));
                continue;
            }
            if (object instanceof Number) {
                this.values.add(((Number)object).longValue());
                continue;
            }
            this.values.add(object);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getFieldCount() {
        return this.values.size();
    }

    public Object getField(int field) {
        Preconditions.checkElementIndex((int)field, (int)this.values.size());
        Object o = this.values.get(field);
        return o instanceof ApproximateDouble ? ((ApproximateDouble)o).getValue() : o;
    }

    public String toString() {
        return this.values.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedRow o = (MaterializedRow)obj;
        return Objects.equals(this.values, o.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    private static class ApproximateDouble {
        private final Double value;
        private final Double normalizedValue;

        private ApproximateDouble(Double value, int precision) {
            this.value = value;
            this.normalizedValue = value.isNaN() || value.isInfinite() ? value : Double.valueOf(new BigDecimal(value).round(new MathContext(precision)).doubleValue());
        }

        public Double getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ApproximateDouble o = (ApproximateDouble)obj;
            return Objects.equals(this.normalizedValue, o.normalizedValue);
        }

        public int hashCode() {
            return Objects.hash(this.normalizedValue);
        }
    }
}

