/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.Session;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedRow;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;

public class MaterializedResult
implements Iterable<MaterializedRow> {
    public static final int DEFAULT_PRECISION = 5;
    private final List<MaterializedRow> rows;
    private final List<Type> types;
    private final Map<String, String> setSessionProperties;
    private final Set<String> resetSessionProperties;

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types) {
        this(rows, types, (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of());
    }

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types, Map<String, String> setSessionProperties, Set<String> resetSessionProperties) {
        this.rows = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(rows, (Object)"rows is null")));
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.setSessionProperties = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(setSessionProperties, (Object)"setSessionProperties is null")));
        this.resetSessionProperties = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(resetSessionProperties, (Object)"resetSessionProperties is null")));
    }

    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Iterator<MaterializedRow> iterator() {
        return this.rows.iterator();
    }

    public List<MaterializedRow> getMaterializedRows() {
        return this.rows;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedResult o = (MaterializedResult)obj;
        return Objects.equals(this.types, o.types) && Objects.equals(this.rows, o.rows) && Objects.equals(this.setSessionProperties, o.setSessionProperties) && Objects.equals(this.resetSessionProperties, o.resetSessionProperties);
    }

    public int hashCode() {
        return Objects.hash(this.rows, this.types, this.setSessionProperties, this.resetSessionProperties);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rows", this.rows).add("types", this.types).add("setSessionProperties", this.setSessionProperties).add("resetSessionProperties", this.resetSessionProperties).toString();
    }

    public MaterializedResult toJdbcTypes() {
        ImmutableList.Builder jdbcRows = ImmutableList.builder();
        for (MaterializedRow row : this.rows) {
            jdbcRows.add((Object)MaterializedResult.convertToJdbcTypes(row));
        }
        return new MaterializedResult((List<MaterializedRow>)jdbcRows.build(), this.types, this.setSessionProperties, this.resetSessionProperties);
    }

    private static MaterializedRow convertToJdbcTypes(MaterializedRow prestoRow) {
        ArrayList<Object> jdbcValues = new ArrayList<Object>();
        for (int field = 0; field < prestoRow.getFieldCount(); ++field) {
            Object jdbcValue;
            Object prestoValue = prestoRow.getField(field);
            if (prestoValue instanceof SqlDate) {
                int days = ((SqlDate)prestoValue).getDays();
                jdbcValue = new Date(TimeUnit.DAYS.toMillis(days));
            } else {
                jdbcValue = prestoValue instanceof SqlTime ? new Time(((SqlTime)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimeWithTimeZone ? new Time(((SqlTimeWithTimeZone)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimestamp ? new Timestamp(((SqlTimestamp)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimestampWithTimeZone ? new Timestamp(((SqlTimestampWithTimeZone)prestoValue).getMillisUtc()) : prestoValue)));
            }
            jdbcValues.add(jdbcValue);
        }
        return new MaterializedRow(prestoRow.getPrecision(), jdbcValues);
    }

    public MaterializedResult toTimeZone(DateTimeZone oldTimeZone, DateTimeZone newTimeZone) {
        ImmutableList.Builder jdbcRows = ImmutableList.builder();
        for (MaterializedRow row : this.rows) {
            jdbcRows.add((Object)MaterializedResult.toTimeZone(row, oldTimeZone, newTimeZone));
        }
        return new MaterializedResult((List<MaterializedRow>)jdbcRows.build(), this.types);
    }

    private static MaterializedRow toTimeZone(MaterializedRow prestoRow, DateTimeZone oldTimeZone, DateTimeZone newTimeZone) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int field = 0; field < prestoRow.getFieldCount(); ++field) {
            Object value = prestoRow.getField(field);
            if (value instanceof Date) {
                long oldMillis = ((Date)value).getTime();
                long newMillis = oldTimeZone.getMillisKeepLocal(newTimeZone, oldMillis);
                value = new Date(newMillis);
            }
            values.add(value);
        }
        return new MaterializedRow(prestoRow.getPrecision(), values);
    }

    public static MaterializedResult materializeSourceDataStream(Session session, ConnectorPageSource pageSource, List<Type> types) {
        return MaterializedResult.materializeSourceDataStream(session.toConnectorSession(), pageSource, types);
    }

    public static MaterializedResult materializeSourceDataStream(ConnectorSession session, ConnectorPageSource pageSource, List<Type> types) {
        Page outputPage;
        Builder builder = MaterializedResult.resultBuilder(session, types);
        while (!pageSource.isFinished() && (outputPage = pageSource.getNextPage()) != null) {
            builder.page(outputPage);
        }
        return builder.build();
    }

    public static Builder resultBuilder(Session session, Type ... types) {
        return MaterializedResult.resultBuilder(session.toConnectorSession(), types);
    }

    public static Builder resultBuilder(Session session, Iterable<? extends Type> types) {
        return MaterializedResult.resultBuilder(session.toConnectorSession(), types);
    }

    public static Builder resultBuilder(ConnectorSession session, Type ... types) {
        return MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)ImmutableList.copyOf((Object[])types));
    }

    public static Builder resultBuilder(ConnectorSession session, Iterable<? extends Type> types) {
        return new Builder(session, (List<Type>)ImmutableList.copyOf(types));
    }

    public static class Builder {
        private final ConnectorSession session;
        private final List<Type> types;
        private final ImmutableList.Builder<MaterializedRow> rows = ImmutableList.builder();

        Builder(ConnectorSession session, List<Type> types) {
            this.session = session;
            this.types = ImmutableList.copyOf(types);
        }

        public Builder rows(List<MaterializedRow> rows) {
            this.rows.addAll(rows);
            return this;
        }

        public Builder row(Object ... values) {
            this.rows.add((Object)new MaterializedRow(5, values));
            return this;
        }

        public Builder rows(Object[][] rows) {
            for (Object[] row : rows) {
                this.row(row);
            }
            return this;
        }

        public Builder pages(Iterable<Page> pages) {
            for (Page page : pages) {
                this.page(page);
            }
            return this;
        }

        public Builder page(Page page) {
            Preconditions.checkNotNull((Object)page, (Object)"page is null");
            Preconditions.checkArgument((page.getChannelCount() == this.types.size() ? 1 : 0) != 0, (String)"Expected a page with %s columns, but got %s columns", (Object[])new Object[]{this.types.size(), page.getChannelCount()});
            for (int position = 0; position < page.getPositionCount(); ++position) {
                ArrayList<Object> values = new ArrayList(page.getChannelCount());
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    Type type = this.types.get(channel);
                    Block block = page.getBlock(channel);
                    values.add(type.getObjectValue(this.session, block, position));
                }
                values = Collections.unmodifiableList(values);
                this.rows.add((Object)new MaterializedRow(5, values));
            }
            return this;
        }

        public MaterializedResult build() {
            return new MaterializedResult((List<MaterializedRow>)this.rows.build(), this.types);
        }
    }
}

