/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class UnnestNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> replicateSymbols;
    private final Map<Symbol, List<Symbol>> unnestSymbols;
    private final Optional<Symbol> ordinalitySymbol;

    @JsonCreator
    public UnnestNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="replicateSymbols") List<Symbol> replicateSymbols, @JsonProperty(value="unnestSymbols") Map<Symbol, List<Symbol>> unnestSymbols, @JsonProperty(value="ordinalitySymbol") Optional<Symbol> ordinalitySymbol) {
        super(id);
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.replicateSymbols = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(replicateSymbols, (Object)"replicateSymbols is null")));
        Preconditions.checkNotNull(unnestSymbols, (Object)"unnestSymbols is null");
        Preconditions.checkArgument((!unnestSymbols.isEmpty() ? 1 : 0) != 0, (Object)"unnestSymbols is empty");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Symbol, List<Symbol>> entry : unnestSymbols.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableList.copyOf((Collection)entry.getValue()));
        }
        this.unnestSymbols = builder.build();
        this.ordinalitySymbol = (Optional)Preconditions.checkNotNull(ordinalitySymbol, (Object)"ordinalitySymbol is null");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder outputSymbolsBuilder = ImmutableList.builder().addAll(this.replicateSymbols).addAll(Iterables.concat(this.unnestSymbols.values()));
        this.ordinalitySymbol.ifPresent(arg_0 -> ((ImmutableList.Builder)outputSymbolsBuilder).add(arg_0));
        return outputSymbolsBuilder.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getReplicateSymbols() {
        return this.replicateSymbols;
    }

    @JsonProperty
    public Map<Symbol, List<Symbol>> getUnnestSymbols() {
        return this.unnestSymbols;
    }

    @JsonProperty
    public Optional<Symbol> getOrdinalitySymbol() {
        return this.ordinalitySymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitUnnest(this, context);
    }
}

