/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TopNNode
extends PlanNode {
    private final PlanNode source;
    private final long count;
    private final List<Symbol> orderBy;
    private final Map<Symbol, SortOrder> orderings;
    private final boolean partial;

    @JsonCreator
    public TopNNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count, @JsonProperty(value="orderBy") List<Symbol> orderBy, @JsonProperty(value="orderings") Map<Symbol, SortOrder> orderings, @JsonProperty(value="partial") boolean partial) {
        super(id);
        Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count must be positive");
        Preconditions.checkNotNull(orderBy, (Object)"orderBy is null");
        Preconditions.checkArgument((!orderBy.isEmpty() ? 1 : 0) != 0, (Object)"orderBy is empty");
        Preconditions.checkArgument((orderings.size() == orderBy.size() ? 1 : 0) != 0, (Object)"orderBy and orderings sizes don't match");
        this.source = source;
        this.count = count;
        this.orderBy = ImmutableList.copyOf(orderBy);
        this.orderings = ImmutableMap.copyOf(orderings);
        this.partial = partial;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @JsonProperty(value="count")
    public long getCount() {
        return this.count;
    }

    @JsonProperty(value="orderBy")
    public List<Symbol> getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty(value="orderings")
    public Map<Symbol, SortOrder> getOrderings() {
        return this.orderings;
    }

    @JsonProperty(value="partial")
    public boolean isPartial() {
        return this.partial;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTopN(this, context);
    }
}

