/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.SampledRelation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SampleNode
extends PlanNode {
    private final PlanNode source;
    private final double sampleRatio;
    private final Type sampleType;
    private final boolean rescaled;
    private final Optional<Symbol> sampleWeightSymbol;

    @JsonCreator
    public SampleNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="sampleRatio") double sampleRatio, @JsonProperty(value="sampleType") Type sampleType, @JsonProperty(value="rescaled") boolean rescaled, @JsonProperty(value="sampleWeightSymbol") Optional<Symbol> sampleWeightSymbol) {
        super(id);
        Preconditions.checkArgument((sampleRatio >= 0.0 ? 1 : 0) != 0, (Object)"sample ratio must be greater than or equal to 0");
        Preconditions.checkArgument((sampleRatio <= 1.0 || sampleType == Type.POISSONIZED ? 1 : 0) != 0, (Object)"sample ratio must be less than or equal to 1");
        this.sampleType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)sampleType), (Object)"sample type is null"));
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.sampleRatio = sampleRatio;
        this.rescaled = rescaled;
        Preconditions.checkArgument((!rescaled || sampleType == Type.POISSONIZED ? 1 : 0) != 0);
        this.sampleWeightSymbol = (Optional)Preconditions.checkNotNull(sampleWeightSymbol, (Object)"sample weight symbol is null");
        Preconditions.checkArgument((sampleWeightSymbol.isPresent() == (sampleType == Type.POISSONIZED) ? 1 : 0) != 0, (Object)"sample weight symbol must be used with POISSONIZED sampling");
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public boolean isRescaled() {
        return this.rescaled;
    }

    @JsonProperty
    public Optional<Symbol> getSampleWeightSymbol() {
        return this.sampleWeightSymbol;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public double getSampleRatio() {
        return this.sampleRatio;
    }

    @JsonProperty
    public Type getSampleType() {
        return this.sampleType;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        if (this.sampleWeightSymbol.isPresent()) {
            return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.sampleWeightSymbol.get()).build();
        }
        return this.source.getOutputSymbols();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitSample(this, context);
    }

    public static enum Type {
        BERNOULLI,
        POISSONIZED,
        SYSTEM;


        public static Type fromType(SampledRelation.Type sampleType) {
            switch (sampleType) {
                case BERNOULLI: {
                    return BERNOULLI;
                }
                case POISSONIZED: {
                    return POISSONIZED;
                }
                case SYSTEM: {
                    return SYSTEM;
                }
            }
            throw new UnsupportedOperationException("Unsupported sample type: " + sampleType);
        }
    }
}

