/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RowNumberNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> partitionBy;
    private final Optional<Integer> maxRowCountPerPartition;
    private final Symbol rowNumberSymbol;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public RowNumberNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="rowNumberSymbol") Symbol rowNumberSymbol, @JsonProperty(value="maxRowCountPerPartition") Optional<Integer> maxRowCountPerPartition, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol) {
        super(id);
        Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkNotNull(partitionBy, (Object)"partitionBy is null");
        Preconditions.checkNotNull((Object)rowNumberSymbol, (Object)"rowNumberSymbol is null");
        Preconditions.checkNotNull(maxRowCountPerPartition, (Object)"maxRowCountPerPartition is null");
        Preconditions.checkNotNull(hashSymbol, (Object)"hashSymbol is null");
        this.source = source;
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.rowNumberSymbol = rowNumberSymbol;
        this.maxRowCountPerPartition = maxRowCountPerPartition;
        this.hashSymbol = hashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), (Iterable)ImmutableList.of((Object)this.rowNumberSymbol)));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public Symbol getRowNumberSymbol() {
        return this.rowNumberSymbol;
    }

    @JsonProperty
    public Optional<Integer> getMaxRowCountPerPartition() {
        return this.maxRowCountPerPartition;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitRowNumber(this, context);
    }
}

