/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import java.util.List;

public abstract class PlanRewriter<C>
extends PlanVisitor<RewriteContext<C>, PlanNode> {
    public static <C> PlanNode rewriteWith(PlanRewriter<C> rewriter, PlanNode node) {
        return (PlanNode)node.accept(rewriter, new RewriteContext(rewriter, null));
    }

    public static <C> PlanNode rewriteWith(PlanRewriter<C> rewriter, PlanNode node, C context) {
        return (PlanNode)node.accept(rewriter, new RewriteContext(rewriter, context));
    }

    @Override
    protected PlanNode visitPlan(PlanNode node, RewriteContext<C> context) {
        return context.defaultRewrite(node, context.get());
    }

    public static class RewriteContext<C> {
        private final C userContext;
        private final PlanRewriter<C> nodeRewriter;

        private RewriteContext(PlanRewriter<C> nodeRewriter, C userContext) {
            this.nodeRewriter = nodeRewriter;
            this.userContext = userContext;
        }

        public C get() {
            return this.userContext;
        }

        public PlanNode defaultRewrite(PlanNode node) {
            return this.defaultRewrite(node, null);
        }

        public PlanNode defaultRewrite(PlanNode node, C context) {
            List children = (List)node.getSources().stream().map(child -> this.rewrite((PlanNode)child, context)).collect(ImmutableCollectors.toImmutableList());
            return this.replaceChildren(node, children);
        }

        public PlanNode replaceChildren(PlanNode node, List<PlanNode> newChildren) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                if (newChildren.get(i) == node.getSources().get(i)) continue;
                return ChildReplacer.replaceChildren(node, newChildren);
            }
            return node;
        }

        public PlanNode rewrite(PlanNode node, C userContext) {
            PlanNode result = (PlanNode)node.accept(this.nodeRewriter, new RewriteContext<C>(this.nodeRewriter, userContext));
            Preconditions.checkNotNull((Object)result, (String)"nodeRewriter returned null for %s", (Object[])new Object[]{node.getClass().getName()});
            return result;
        }

        public PlanNode rewrite(PlanNode node) {
            return this.rewrite(node, null);
        }
    }
}

