/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Join;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JoinNode
extends PlanNode {
    private final Type type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<EquiJoinClause> criteria;
    private final Optional<Symbol> leftHashSymbol;
    private final Optional<Symbol> rightHashSymbol;

    @JsonCreator
    public JoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="leftHashSymbol") Optional<Symbol> leftHashSymbol, @JsonProperty(value="rightHashSymbol") Optional<Symbol> rightHashSymbol) {
        super(id);
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type is null");
        Preconditions.checkNotNull((Object)left, (Object)"left is null");
        Preconditions.checkNotNull((Object)right, (Object)"right is null");
        Preconditions.checkNotNull(criteria, (Object)"criteria is null");
        Preconditions.checkNotNull(leftHashSymbol, (Object)"leftHashSymbol is null");
        Preconditions.checkNotNull(rightHashSymbol, (Object)"rightHashSymbol is null");
        this.type = type;
        this.left = left;
        this.right = right;
        this.criteria = ImmutableList.copyOf(criteria);
        this.leftHashSymbol = leftHashSymbol;
        this.rightHashSymbol = rightHashSymbol;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="left")
    public PlanNode getLeft() {
        return this.left;
    }

    @JsonProperty(value="right")
    public PlanNode getRight() {
        return this.right;
    }

    @JsonProperty(value="criteria")
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty(value="leftHashSymbol")
    public Optional<Symbol> getLeftHashSymbol() {
        return this.leftHashSymbol;
    }

    @JsonProperty(value="rightHashSymbol")
    public Optional<Symbol> getRightHashSymbol() {
        return this.rightHashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.left.getOutputSymbols()).addAll(this.right.getOutputSymbols()).build();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    public static class EquiJoinClause {
        private final Symbol left;
        private final Symbol right;

        @JsonCreator
        public EquiJoinClause(@JsonProperty(value="left") Symbol left, @JsonProperty(value="right") Symbol right) {
            this.left = (Symbol)Preconditions.checkNotNull((Object)left, (Object)"left is null");
            this.right = (Symbol)Preconditions.checkNotNull((Object)right, (Object)"right is null");
        }

        @JsonProperty(value="left")
        public Symbol getLeft() {
            return this.left;
        }

        @JsonProperty(value="right")
        public Symbol getRight() {
            return this.right;
        }
    }

    public static enum Type {
        INNER("InnerJoin"),
        LEFT("LeftJoin"),
        RIGHT("RightJoin"),
        CROSS("CrossJoin"),
        FULL("FullJoin");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }

        public static Type typeConvert(Join.Type joinType) {
            switch (joinType) {
                case INNER: {
                    return INNER;
                }
                case LEFT: {
                    return LEFT;
                }
                case RIGHT: {
                    return RIGHT;
                }
                case FULL: {
                    return FULL;
                }
                case CROSS: 
                case IMPLICIT: {
                    return CROSS;
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + joinType);
        }
    }
}

