/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.IndexHandle;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexSourceNode
extends PlanNode {
    private final IndexHandle indexHandle;
    private final TableHandle tableHandle;
    private final Set<Symbol> lookupSymbols;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final TupleDomain<ColumnHandle> effectiveTupleDomain;

    @JsonCreator
    public IndexSourceNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="indexHandle") IndexHandle indexHandle, @JsonProperty(value="tableHandle") TableHandle tableHandle, @JsonProperty(value="lookupSymbols") Set<Symbol> lookupSymbols, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="effectiveTupleDomain") TupleDomain<ColumnHandle> effectiveTupleDomain) {
        super(id);
        this.indexHandle = (IndexHandle)Preconditions.checkNotNull((Object)indexHandle, (Object)"indexHandle is null");
        this.tableHandle = (TableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        this.lookupSymbols = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(lookupSymbols, (Object)"lookupSymbols is null")));
        this.outputSymbols = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(outputSymbols, (Object)"outputSymbols is null")));
        this.assignments = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(assignments, (Object)"assignments is null")));
        this.effectiveTupleDomain = (TupleDomain)Preconditions.checkNotNull(effectiveTupleDomain, (Object)"effectiveTupleDomain is null");
        Preconditions.checkArgument((!lookupSymbols.isEmpty() ? 1 : 0) != 0, (Object)"lookupSymbols is empty");
        Preconditions.checkArgument((!outputSymbols.isEmpty() ? 1 : 0) != 0, (Object)"outputSymbols is empty");
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(lookupSymbols), (Object)"Assignments do not include all lookup symbols");
        Preconditions.checkArgument((boolean)outputSymbols.containsAll(lookupSymbols), (Object)"Lookup symbols need to be part of the output symbols");
    }

    @JsonProperty
    public IndexHandle getIndexHandle() {
        return this.indexHandle;
    }

    @JsonProperty
    public TableHandle getTableHandle() {
        return this.tableHandle;
    }

    @JsonProperty
    public Set<Symbol> getLookupSymbols() {
        return this.lookupSymbols;
    }

    @Override
    @JsonProperty
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getEffectiveTupleDomain() {
        return this.effectiveTupleDomain;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitIndexSource(this, context);
    }
}

