/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AggregationNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> groupByKeys;
    private final Map<Symbol, FunctionCall> aggregations;
    private final Map<Symbol, Symbol> masks;
    private final Map<Symbol, Signature> functions;
    private final Step step;
    private final Optional<Symbol> sampleWeight;
    private final double confidence;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public AggregationNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="groupBy") List<Symbol> groupByKeys, @JsonProperty(value="aggregations") Map<Symbol, FunctionCall> aggregations, @JsonProperty(value="functions") Map<Symbol, Signature> functions, @JsonProperty(value="masks") Map<Symbol, Symbol> masks, @JsonProperty(value="step") Step step, @JsonProperty(value="sampleWeight") Optional<Symbol> sampleWeight, @JsonProperty(value="confidence") double confidence, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol) {
        super(id);
        this.source = source;
        this.groupByKeys = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(groupByKeys, (Object)"groupByKeys is null")));
        this.aggregations = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(aggregations, (Object)"aggregations is null")));
        this.functions = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(functions, (Object)"functions is null")));
        this.masks = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(masks, (Object)"masks is null")));
        for (Symbol mask : masks.keySet()) {
            Preconditions.checkArgument((boolean)aggregations.containsKey(mask), (Object)"mask does not match any aggregations");
        }
        this.step = step;
        this.sampleWeight = (Optional)Preconditions.checkNotNull(sampleWeight, (Object)"sampleWeight is null");
        Preconditions.checkArgument((confidence >= 0.0 && confidence <= 1.0 ? 1 : 0) != 0, (Object)"confidence must be in [0, 1]");
        this.confidence = confidence;
        this.hashSymbol = hashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder symbols = ImmutableList.builder();
        symbols.addAll(this.groupByKeys);
        if (this.hashSymbol.isPresent()) {
            symbols.add((Object)this.hashSymbol.get());
        }
        symbols.addAll(this.aggregations.keySet());
        return symbols.build();
    }

    @JsonProperty(value="confidence")
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty(value="aggregations")
    public Map<Symbol, FunctionCall> getAggregations() {
        return this.aggregations;
    }

    @JsonProperty(value="functions")
    public Map<Symbol, Signature> getFunctions() {
        return this.functions;
    }

    @JsonProperty(value="masks")
    public Map<Symbol, Symbol> getMasks() {
        return this.masks;
    }

    @JsonProperty(value="groupBy")
    public List<Symbol> getGroupBy() {
        return this.groupByKeys;
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="step")
    public Step getStep() {
        return this.step;
    }

    @JsonProperty(value="sampleWeight")
    public Optional<Symbol> getSampleWeight() {
        return this.sampleWeight;
    }

    @JsonProperty(value="hashSymbol")
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    public static enum Step {
        PARTIAL,
        FINAL,
        SINGLE;

    }
}

