/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class PruneRedundantProjections
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends PlanRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitProject(ProjectNode node, PlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            if (node.getOutputSymbols().size() != source.getOutputSymbols().size()) {
                return context.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
            }
            boolean canElide = true;
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                Expression expression = entry.getValue();
                Symbol symbol = entry.getKey();
                if (expression instanceof QualifiedNameReference && ((QualifiedNameReference)expression).getName().equals((Object)symbol.toQualifiedName())) continue;
                canElide = false;
                break;
            }
            if (canElide) {
                return source;
            }
            return context.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }
    }
}

