/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConstantProperty;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class PropertyDerivations {
    private PropertyDerivations() {
    }

    public static ActualProperties deriveProperties(PlanNode node, ActualProperties inputProperties, Metadata metadata, Session session, Map<Symbol, Type> types, SqlParser parser) {
        return PropertyDerivations.deriveProperties(node, (List<ActualProperties>)ImmutableList.of((Object)inputProperties), metadata, session, types, parser);
    }

    public static ActualProperties deriveProperties(PlanNode node, List<ActualProperties> inputProperties, Metadata metadata, Session session, Map<Symbol, Type> types, SqlParser parser) {
        return node.accept(new Visitor(metadata, session, types, parser), inputProperties);
    }

    private static class Visitor
    extends PlanVisitor<List<ActualProperties>, ActualProperties> {
        private final Metadata metadata;
        private final Session session;
        private final Map<Symbol, Type> types;
        private final SqlParser parser;

        public Visitor(Metadata metadata, Session session, Map<Symbol, Type> types, SqlParser parser) {
            this.metadata = metadata;
            this.session = session;
            this.types = types;
            this.parser = parser;
        }

        @Override
        protected ActualProperties visitPlan(PlanNode node, List<ActualProperties> inputProperties) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public ActualProperties visitOutput(OutputNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitMarkDistinct(MarkDistinctNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitWindow(WindowNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            if (ImmutableSet.copyOf(node.getPartitionBy()).equals(node.getPrePartitionedInputs()) && node.getPreSortedOrderPrefix() == node.getOrderBy().size()) {
                return properties;
            }
            ImmutableList.Builder localProperties = ImmutableList.builder();
            if (!node.getPartitionBy().isEmpty()) {
                localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            }
            for (Symbol column : node.getOrderBy()) {
                localProperties.add((Object)new SortingProperty((Object)column, node.getOrderings().get(column)));
            }
            return ActualProperties.builderFrom(properties).local((List<? extends LocalProperty<Symbol>>)localProperties.build()).build();
        }

        @Override
        public ActualProperties visitAggregation(AggregationNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ActualProperties translated = properties.translate(symbol -> node.getGroupBy().contains(symbol) ? Optional.of(symbol) : Optional.empty());
            return ActualProperties.builderFrom(translated).local(LocalProperties.grouped(node.getGroupBy())).build();
        }

        @Override
        public ActualProperties visitRowNumber(RowNumberNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitTopNRowNumber(TopNRowNumberNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            ImmutableList.Builder localProperties = ImmutableList.builder();
            localProperties.add((Object)new GroupingProperty(node.getPartitionBy()));
            for (Symbol column : node.getOrderBy()) {
                localProperties.add((Object)new SortingProperty((Object)column, node.getOrderings().get(column)));
            }
            return ActualProperties.builderFrom(properties).local((List<? extends LocalProperty<Symbol>>)localProperties.build()).build();
        }

        @Override
        public ActualProperties visitTopN(TopNNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            List localProperties = (List)node.getOrderBy().stream().map(column -> new SortingProperty(column, node.getOrderings().get(column))).collect(ImmutableCollectors.toImmutableList());
            return ActualProperties.builderFrom(properties).local(localProperties).build();
        }

        @Override
        public ActualProperties visitSort(SortNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            List localProperties = (List)node.getOrderBy().stream().map(column -> new SortingProperty(column, node.getOrderings().get(column))).collect(ImmutableCollectors.toImmutableList());
            return ActualProperties.builderFrom(properties).local(localProperties).build();
        }

        @Override
        public ActualProperties visitLimit(LimitNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitDistinctLimit(DistinctLimitNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            return ActualProperties.builderFrom(properties).local(LocalProperties.grouped(node.getDistinctSymbols())).build();
        }

        @Override
        public ActualProperties visitTableCommit(TableCommitNode node, List<ActualProperties> inputProperties) {
            return ActualProperties.builder().global(ActualProperties.Global.coordinatorOnly()).build();
        }

        @Override
        public ActualProperties visitDelete(DeleteNode node, List<ActualProperties> inputProperties) {
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translate(symbol -> Optional.empty());
        }

        @Override
        public ActualProperties visitJoin(JoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties buildProperties = inputProperties.get(1);
            return ActualProperties.builderFrom(probeProperties).constants((Map<Symbol, Object>)ImmutableMap.builder().putAll(probeProperties.getConstants()).putAll(buildProperties.getConstants()).build()).build();
        }

        @Override
        public ActualProperties visitSemiJoin(SemiJoinNode node, List<ActualProperties> inputProperties) {
            return inputProperties.get(0);
        }

        @Override
        public ActualProperties visitIndexJoin(IndexJoinNode node, List<ActualProperties> inputProperties) {
            ActualProperties probeProperties = inputProperties.get(0);
            ActualProperties indexProperties = inputProperties.get(1);
            return ActualProperties.builderFrom(probeProperties).constants((Map<Symbol, Object>)ImmutableMap.builder().putAll(probeProperties.getConstants()).putAll(indexProperties.getConstants()).build()).build();
        }

        @Override
        public ActualProperties visitIndexSource(IndexSourceNode node, List<ActualProperties> context) {
            return ActualProperties.undistributed();
        }

        public static Map<Symbol, Symbol> exchangeInputToOutput(ExchangeNode node, int sourceIndex) {
            List<Symbol> inputSymbols = node.getInputs().get(sourceIndex);
            HashMap<Symbol, Symbol> inputToOutput = new HashMap<Symbol, Symbol>();
            for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                inputToOutput.put(inputSymbols.get(i), node.getOutputSymbols().get(i));
            }
            return inputToOutput;
        }

        @Override
        public ActualProperties visitExchange(ExchangeNode node, List<ActualProperties> inputProperties) {
            Sets.SetView entries = null;
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                Map<Symbol, Symbol> inputToOutput = Visitor.exchangeInputToOutput(node, sourceIndex);
                ActualProperties translated = inputProperties.get(sourceIndex).translate(symbol -> Optional.of(inputToOutput.get(symbol)));
                entries = entries == null ? translated.getConstants().entrySet() : Sets.intersection(entries, translated.getConstants().entrySet());
            }
            Preconditions.checkState((entries != null ? 1 : 0) != 0);
            Map<Symbol, Object> constants = entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            switch (node.getType()) {
                case GATHER: {
                    return ActualProperties.builder().global(ActualProperties.Global.undistributed()).constants(constants).build();
                }
                case REPARTITION: {
                    if (!node.getPartitionKeys().isPresent()) {
                        return ActualProperties.builder().global(ActualProperties.Global.distributed()).constants(constants).build();
                    }
                    return ActualProperties.builder().global(ActualProperties.Global.distributed(ActualProperties.Partitioning.hashPartitioned(node.getPartitionKeys().get()))).constants(constants).build();
                }
                case REPARTITION_WITH_NULL_REPLICATION: {
                    return ActualProperties.builder().global(ActualProperties.Global.distributed(ActualProperties.Partitioning.hashPartitionedWithReplicatedNulls(node.getPartitionKeys().get()))).constants(constants).build();
                }
                case REPLICATE: {
                    return ActualProperties.builder().global(ActualProperties.Global.distributed()).constants(constants).build();
                }
            }
            throw new UnsupportedOperationException("not yet implemented");
        }

        @Override
        public ActualProperties visitFilter(FilterNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(this.metadata, this.session, node.getPredicate(), this.types);
            HashMap<Symbol, Object> constants = new HashMap<Symbol, Object>(properties.getConstants());
            constants.putAll(decomposedPredicate.getTupleDomain().extractFixedValues());
            return ActualProperties.builderFrom(properties).constants(constants).build();
        }

        @Override
        public ActualProperties visitProject(ProjectNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            Map<Symbol, Symbol> identities = Visitor.computeIdentityTranslations(node.getAssignments());
            ActualProperties translatedProperties = properties.translate(column -> Optional.ofNullable(identities.get(column)));
            HashMap<Symbol, Object> constants = new HashMap<Symbol, Object>();
            for (Map.Entry<Symbol, Expression> assignment : node.getAssignments().entrySet()) {
                IdentityHashMap<Expression, Type> expressionTypes;
                Expression expression = assignment.getValue();
                ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.parser, this.types, expression));
                Object value = optimizer.optimize(NoOpSymbolResolver.INSTANCE);
                if (value instanceof QualifiedNameReference) {
                    Symbol symbol = Symbol.fromQualifiedName(((QualifiedNameReference)value).getName());
                    value = constants.getOrDefault(symbol, value);
                }
                if (value == null || value instanceof Expression) continue;
                constants.put(assignment.getKey(), value);
            }
            constants.putAll(translatedProperties.getConstants());
            return ActualProperties.builderFrom(translatedProperties).constants(constants).build();
        }

        @Override
        public ActualProperties visitTableWriter(TableWriterNode node, List<ActualProperties> inputProperties) {
            ActualProperties properties = (ActualProperties)Iterables.getOnlyElement(inputProperties);
            if (properties.isCoordinatorOnly()) {
                return ActualProperties.builder().global(ActualProperties.Global.coordinatorOnly()).build();
            }
            return properties.isDistributed() ? ActualProperties.distributed() : ActualProperties.undistributed();
        }

        @Override
        public ActualProperties visitSample(SampleNode node, List<ActualProperties> inputProperties) {
            return (ActualProperties)Iterables.getOnlyElement(inputProperties);
        }

        @Override
        public ActualProperties visitUnnest(UnnestNode node, List<ActualProperties> inputProperties) {
            ImmutableSet passThroughInputs = ImmutableSet.copyOf(node.getReplicateSymbols());
            return ((ActualProperties)Iterables.getOnlyElement(inputProperties)).translate(arg_0 -> Visitor.lambda$visitUnnest$206((Set)passThroughInputs, arg_0));
        }

        @Override
        public ActualProperties visitTableScan(TableScanNode node, List<ActualProperties> inputProperties) {
            Preconditions.checkArgument((boolean)node.getLayout().isPresent(), (Object)"table layout has not yet been chosen");
            TableLayout layout = this.metadata.getLayout(this.session, node.getLayout().get());
            ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            ActualProperties.Builder properties = ActualProperties.builder();
            HashMap constants = new HashMap();
            LocalProperties.extractLeadingConstants(layout.getLocalProperties()).stream().forEach(column -> constants.put(column, new Object()));
            node.getCurrentConstraint().extractFixedValues().entrySet().stream().forEach(entry -> constants.put(entry.getKey(), entry.getValue()));
            Map<Symbol, Object> symbolConstants = constants.entrySet().stream().filter(arg_0 -> Visitor.lambda$visitTableScan$209((Map)assignments, arg_0)).collect(Collectors.toMap(arg_0 -> Visitor.lambda$visitTableScan$210((Map)assignments, arg_0), Map.Entry::getValue));
            properties.constants(symbolConstants);
            Optional<Object> partitioningColumns = Optional.empty();
            if (layout.getPartitioningColumns().isPresent()) {
                Set constantsStrippedPartitionColumns = (Set)layout.getPartitioningColumns().get().stream().filter(column -> !constants.containsKey(column)).collect(ImmutableCollectors.toImmutableSet());
                partitioningColumns = Visitor.translate(constantsStrippedPartitionColumns, assignments);
            }
            if (partitioningColumns.isPresent()) {
                properties.global(ActualProperties.Global.distributed(ActualProperties.Partitioning.partitioned((Set<Symbol>)ImmutableSet.copyOf((Collection)((Collection)partitioningColumns.get())))));
            } else {
                properties.global(ActualProperties.Global.distributed());
            }
            ImmutableList constantAppendedLocalProperties = ImmutableList.builder().addAll(constants.keySet().stream().map(column -> new ConstantProperty(column)).iterator()).addAll(layout.getLocalProperties()).build();
            properties.local(LocalProperties.translate(constantAppendedLocalProperties, arg_0 -> Visitor.lambda$visitTableScan$213((Map)assignments, arg_0)));
            return properties.build();
        }

        private static Map<Symbol, Symbol> computeIdentityTranslations(Map<Symbol, Expression> assignments) {
            HashMap<Symbol, Symbol> inputToOutput = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
                if (!(assignment.getValue() instanceof QualifiedNameReference)) continue;
                inputToOutput.put(Symbol.fromQualifiedName(((QualifiedNameReference)assignment.getValue()).getName()), assignment.getKey());
            }
            return inputToOutput;
        }

        private static <T> Optional<List<Symbol>> translate(Collection<T> columns, Map<T, Symbol> mappings) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (T column : columns) {
                Symbol translated = mappings.get(column);
                if (translated == null) {
                    return Optional.empty();
                }
                builder.add((Object)translated);
            }
            return Optional.of(builder.build());
        }

        private static /* synthetic */ Optional lambda$visitTableScan$213(Map map, ColumnHandle column) {
            return Optional.ofNullable(map.get(column));
        }

        private static /* synthetic */ Symbol lambda$visitTableScan$210(Map map, Map.Entry entry) {
            return (Symbol)map.get(entry.getKey());
        }

        private static /* synthetic */ boolean lambda$visitTableScan$209(Map map, Map.Entry entry) {
            return map.containsKey(entry.getKey());
        }

        private static /* synthetic */ Optional lambda$visitUnnest$206(Set set, Symbol column) {
            if (set.contains(column)) {
                return Optional.of(column);
            }
            return Optional.empty();
        }
    }
}

