/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PickLayout
extends PlanOptimizer {
    private final Metadata metadata;

    public PickLayout(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return PlanRewriter.rewriteWith(new Rewriter(this.metadata, session, symbolAllocator, idAllocator), plan);
    }

    private static class Rewriter
    extends PlanRewriter<Void> {
        private final Metadata metadata;
        private final Session session;
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;

        public Rewriter(Metadata metadata, Session session, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
            this.metadata = metadata;
            this.session = session;
            this.symbolAllocator = symbolAllocator;
            this.idAllocator = idAllocator;
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, PlanRewriter.RewriteContext<Void> context) {
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitFilter(FilterNode node, PlanRewriter.RewriteContext<Void> context) {
            if (node.getSource() instanceof TableScanNode && !((TableScanNode)node.getSource()).getLayout().isPresent()) {
                return this.planTableScan((TableScanNode)node.getSource(), node.getPredicate());
            }
            return context.defaultRewrite(node);
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, PlanRewriter.RewriteContext<Void> context) {
            if (node.getLayout().isPresent()) {
                return node;
            }
            return this.planTableScan(node, (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        private PlanNode planTableScan(TableScanNode node, Expression predicate) {
            DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(this.metadata, this.session, predicate, this.symbolAllocator.getTypes());
            TupleDomain simplifiedConstraint = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getCurrentConstraint());
            List<TableLayoutResult> layouts = this.metadata.getLayouts(this.session, node.getTable(), (Constraint<ColumnHandle>)new Constraint(simplifiedConstraint, bindings -> true), Optional.of(ImmutableSet.copyOf(node.getAssignments().values())));
            if (layouts.isEmpty()) {
                return new ValuesNode(this.idAllocator.getNextId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of());
            }
            TableLayoutResult layout = layouts.get(0);
            TableScanNode result = new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), Optional.of(layout.getLayout().getHandle()), (TupleDomain<ColumnHandle>)simplifiedConstraint.intersect(layout.getLayout().getPredicate()), Optional.ofNullable(node.getOriginalConstraint()).orElse(predicate));
            ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = decomposedPredicate.getRemainingExpression();
            expressionArray[1] = DomainTranslator.toPredicate((TupleDomain<Symbol>)layout.getUnenforcedConstraint().transform(((Map)assignments)::get), this.symbolAllocator.getTypes());
            Expression resultingPredicate = ExpressionUtils.combineConjuncts(expressionArray);
            if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
                return new FilterNode(this.idAllocator.getNextId(), result, resultingPredicate);
            }
            return result;
        }
    }
}

