/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.ResolvedIndex;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class IndexJoinOptimizer
extends PlanOptimizer {
    private final IndexManager indexManager;
    private final Metadata metadata;

    public IndexJoinOptimizer(Metadata metadata, IndexManager indexManager) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.indexManager = Objects.requireNonNull(indexManager, "indexManager is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(symbolAllocator, idAllocator, this.indexManager, this.metadata, session), plan, null);
    }

    private static Symbol referenceToSymbol(Expression expression) {
        Preconditions.checkArgument((boolean)(expression instanceof QualifiedNameReference));
        return Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
    }

    public static class IndexKeyTracer {
        public static Map<Symbol, Symbol> trace(PlanNode node, Set<Symbol> lookupSymbols) {
            return node.accept(new Visitor(), lookupSymbols);
        }

        private static class Visitor
        extends PlanVisitor<Set<Symbol>, Map<Symbol, Symbol>> {
            private Visitor() {
            }

            @Override
            protected Map<Symbol, Symbol> visitPlan(PlanNode node, Set<Symbol> lookupSymbols) {
                throw new UnsupportedOperationException("Node not expected to be part of Index pipeline: " + node);
            }

            @Override
            public Map<Symbol, Symbol> visitProject(ProjectNode node, Set<Symbol> lookupSymbols) {
                Map directSymbolTranslationOutputMap = Maps.transformValues((Map)Maps.filterValues(node.getAssignments(), QualifiedNameReference.class::isInstance), x$0 -> IndexJoinOptimizer.referenceToSymbol(x$0));
                ImmutableMap outputToSourceMap = FluentIterable.from(lookupSymbols).filter(Predicates.in(directSymbolTranslationOutputMap.keySet())).toMap(Functions.forMap((Map)directSymbolTranslationOutputMap));
                Preconditions.checkState((!outputToSourceMap.isEmpty() ? 1 : 0) != 0, (Object)"No lookup symbols were able to pass through the projection");
                Map<Symbol, Symbol> sourceToIndexMap = node.getSource().accept(this, ImmutableSet.copyOf(outputToSourceMap.values()));
                Map outputToIndexMap = Maps.transformValues((Map)Maps.filterValues((Map)outputToSourceMap, (Predicate)Predicates.in(sourceToIndexMap.keySet())), (Function)Functions.forMap(sourceToIndexMap));
                return ImmutableMap.copyOf((Map)outputToIndexMap);
            }

            @Override
            public Map<Symbol, Symbol> visitFilter(FilterNode node, Set<Symbol> lookupSymbols) {
                return node.getSource().accept(this, lookupSymbols);
            }

            @Override
            public Map<Symbol, Symbol> visitIndexJoin(IndexJoinNode node, Set<Symbol> lookupSymbols) {
                ImmutableSet probeLookupSymbols = FluentIterable.from(lookupSymbols).filter(Predicates.in(node.getProbeSource().getOutputSymbols())).toSet();
                Preconditions.checkState((!probeLookupSymbols.isEmpty() ? 1 : 0) != 0, (Object)"No lookup symbols were able to pass through the index join probe source");
                return node.getProbeSource().accept(this, probeLookupSymbols);
            }

            @Override
            public Map<Symbol, Symbol> visitAggregation(AggregationNode node, Set<Symbol> lookupSymbols) {
                ImmutableSet groupByLookupSymbols = FluentIterable.from(lookupSymbols).filter(Predicates.in(node.getGroupBy())).toSet();
                Preconditions.checkState((!groupByLookupSymbols.isEmpty() ? 1 : 0) != 0, (Object)"No lookup symbols were able to pass through the aggregation group by");
                return node.getSource().accept(this, groupByLookupSymbols);
            }

            @Override
            public Map<Symbol, Symbol> visitSort(SortNode node, Set<Symbol> lookupSymbols) {
                return node.getSource().accept(this, lookupSymbols);
            }

            @Override
            public Map<Symbol, Symbol> visitIndexSource(IndexSourceNode node, Set<Symbol> lookupSymbols) {
                Preconditions.checkState((boolean)node.getLookupSymbols().equals(lookupSymbols), (Object)"lookupSymbols must be the same as IndexSource lookup symbols");
                return FluentIterable.from(lookupSymbols).toMap(Functions.identity());
            }
        }
    }

    private static class IndexSourceRewriter
    extends PlanRewriter<Context> {
        private final IndexManager indexManager;
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final Session session;

        private IndexSourceRewriter(IndexManager indexManager, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.symbolAllocator = (SymbolAllocator)Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
            this.idAllocator = (PlanNodeIdAllocator)Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
            this.indexManager = (IndexManager)Preconditions.checkNotNull((Object)indexManager, (Object)"indexManager is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public static Optional<PlanNode> rewriteWithIndex(PlanNode planNode, Set<Symbol> lookupSymbols, IndexManager indexManager, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
            AtomicBoolean success = new AtomicBoolean();
            IndexSourceRewriter indexSourceRewriter = new IndexSourceRewriter(indexManager, symbolAllocator, idAllocator, metadata, session);
            PlanNode rewritten = PlanRewriter.rewriteWith(indexSourceRewriter, planNode, new Context(lookupSymbols, success));
            if (success.get()) {
                return Optional.of(rewritten);
            }
            return Optional.empty();
        }

        @Override
        public PlanNode visitPlan(PlanNode node, PlanRewriter.RewriteContext<Context> context) {
            return node;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, PlanRewriter.RewriteContext<Context> context) {
            return this.planTableScan(node, (Expression)BooleanLiteral.TRUE_LITERAL, context.get());
        }

        @NotNull
        private PlanNode planTableScan(TableScanNode node, Expression predicate, Context context) {
            DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(this.metadata, this.session, predicate, this.symbolAllocator.getTypes());
            TupleDomain simplifiedConstraint = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getCurrentConstraint());
            Preconditions.checkState((boolean)node.getOutputSymbols().containsAll(context.getLookupSymbols()));
            ImmutableSet lookupColumns = FluentIterable.from(context.getLookupSymbols()).transform(Functions.forMap(node.getAssignments())).toSet();
            Set outputColumns = (Set)node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableCollectors.toImmutableSet());
            Optional<ResolvedIndex> optionalResolvedIndex = this.indexManager.resolveIndex(this.session, node.getTable(), (Set<ColumnHandle>)lookupColumns, outputColumns, (TupleDomain<ColumnHandle>)simplifiedConstraint);
            if (!optionalResolvedIndex.isPresent()) {
                return node;
            }
            ResolvedIndex resolvedIndex = optionalResolvedIndex.get();
            ImmutableBiMap inverseAssignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            PlanNode source = new IndexSourceNode(this.idAllocator.getNextId(), resolvedIndex.getIndexHandle(), node.getTable(), context.getLookupSymbols(), node.getOutputSymbols(), node.getAssignments(), (TupleDomain<ColumnHandle>)simplifiedConstraint);
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = DomainTranslator.toPredicate((TupleDomain<Symbol>)resolvedIndex.getUnresolvedTupleDomain().transform(((Map)inverseAssignments)::get), this.symbolAllocator.getTypes());
            expressionArray[1] = decomposedPredicate.getRemainingExpression();
            Expression resultingPredicate = ExpressionUtils.combineConjuncts(expressionArray);
            if (!resultingPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                source = new FilterNode(this.idAllocator.getNextId(), source, resultingPredicate);
            }
            context.markSuccess();
            return source;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, PlanRewriter.RewriteContext<Context> context) {
            ImmutableSet newLookupSymbols = FluentIterable.from(context.get().getLookupSymbols()).transform(Functions.forMap(node.getAssignments())).filter(QualifiedNameReference.class::isInstance).transform(x$0 -> IndexJoinOptimizer.referenceToSymbol(x$0)).toSet();
            if (newLookupSymbols.isEmpty()) {
                return node;
            }
            return context.defaultRewrite(node, new Context((Set<Symbol>)newLookupSymbols, context.get().getSuccess()));
        }

        @Override
        public PlanNode visitFilter(FilterNode node, PlanRewriter.RewriteContext<Context> context) {
            if (node.getSource() instanceof TableScanNode) {
                return this.planTableScan((TableScanNode)node.getSource(), node.getPredicate(), context.get());
            }
            return context.defaultRewrite(node, new Context(context.get().getLookupSymbols(), context.get().getSuccess()));
        }

        @Override
        public PlanNode visitIndexSource(IndexSourceNode node, PlanRewriter.RewriteContext<Context> context) {
            throw new IllegalStateException("Should not be trying to generate an Index on something that has already been determined to use an Index");
        }

        @Override
        public PlanNode visitIndexJoin(IndexJoinNode node, PlanRewriter.RewriteContext<Context> context) {
            ImmutableSet probeLookupSymbols = FluentIterable.from(context.get().getLookupSymbols()).filter(Predicates.in(node.getProbeSource().getOutputSymbols())).toSet();
            if (probeLookupSymbols.isEmpty()) {
                return node;
            }
            PlanNode rewrittenProbeSource = context.rewrite(node.getProbeSource(), new Context((Set<Symbol>)probeLookupSymbols, context.get().getSuccess()));
            IndexJoinNode source = node;
            if (rewrittenProbeSource != node.getProbeSource()) {
                source = new IndexJoinNode(node.getId(), node.getType(), rewrittenProbeSource, node.getIndexSource(), node.getCriteria(), node.getProbeHashSymbol(), node.getIndexHashSymbol());
            }
            return source;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, PlanRewriter.RewriteContext<Context> context) {
            ImmutableSet groupByLookupSymbols = FluentIterable.from(context.get().getLookupSymbols()).filter(Predicates.in(node.getGroupBy())).toSet();
            if (groupByLookupSymbols.isEmpty()) {
                return node;
            }
            return context.defaultRewrite(node, new Context((Set<Symbol>)groupByLookupSymbols, context.get().getSuccess()));
        }

        @Override
        public PlanNode visitSort(SortNode node, PlanRewriter.RewriteContext<Context> context) {
            return context.rewrite(node.getSource(), context.get());
        }

        public static class Context {
            private final Set<Symbol> lookupSymbols;
            private final AtomicBoolean success;

            public Context(Set<Symbol> lookupSymbols, AtomicBoolean success) {
                Preconditions.checkArgument((!lookupSymbols.isEmpty() ? 1 : 0) != 0, (Object)"lookupSymbols can not be empty");
                this.lookupSymbols = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(lookupSymbols, (Object)"lookupSymbols is null")));
                this.success = (AtomicBoolean)Preconditions.checkNotNull((Object)success, (Object)"success is null");
            }

            public Set<Symbol> getLookupSymbols() {
                return this.lookupSymbols;
            }

            public AtomicBoolean getSuccess() {
                return this.success;
            }

            public void markSuccess() {
                Preconditions.checkState((boolean)this.success.compareAndSet(false, true), (Object)"Can only have one success per context");
            }
        }
    }

    private static class Rewriter
    extends PlanRewriter<Void> {
        private final IndexManager indexManager;
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final Session session;

        private Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, IndexManager indexManager, Metadata metadata, Session session) {
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.indexManager = Objects.requireNonNull(indexManager, "indexManager is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        @Override
        public PlanNode visitJoin(JoinNode node, PlanRewriter.RewriteContext<Void> context) {
            PlanNode leftRewritten = context.rewrite(node.getLeft());
            PlanNode rightRewritten = context.rewrite(node.getRight());
            if (!node.getCriteria().isEmpty()) {
                Optional<PlanNode> rightIndexCandidate;
                List leftJoinSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getLeft);
                List rightJoinSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight);
                Optional<PlanNode> leftIndexCandidate = IndexSourceRewriter.rewriteWithIndex(leftRewritten, (Set<Symbol>)ImmutableSet.copyOf((Collection)leftJoinSymbols), this.indexManager, this.symbolAllocator, this.idAllocator, this.metadata, this.session);
                if (leftIndexCandidate.isPresent()) {
                    Map<Symbol, Symbol> trace = IndexKeyTracer.trace(leftIndexCandidate.get(), (Set<Symbol>)ImmutableSet.copyOf((Collection)leftJoinSymbols));
                    Preconditions.checkState((!trace.isEmpty() && leftJoinSymbols.containsAll(trace.keySet()) ? 1 : 0) != 0);
                }
                if ((rightIndexCandidate = IndexSourceRewriter.rewriteWithIndex(rightRewritten, (Set<Symbol>)ImmutableSet.copyOf((Collection)rightJoinSymbols), this.indexManager, this.symbolAllocator, this.idAllocator, this.metadata, this.session)).isPresent()) {
                    Map<Symbol, Symbol> trace = IndexKeyTracer.trace(rightIndexCandidate.get(), (Set<Symbol>)ImmutableSet.copyOf((Collection)rightJoinSymbols));
                    Preconditions.checkState((!trace.isEmpty() && rightJoinSymbols.containsAll(trace.keySet()) ? 1 : 0) != 0);
                }
                switch (node.getType()) {
                    case INNER: {
                        if (rightIndexCandidate.isPresent()) {
                            return new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.INNER, leftRewritten, rightIndexCandidate.get(), Rewriter.createEquiJoinClause(leftJoinSymbols, rightJoinSymbols), Optional.empty(), Optional.empty());
                        }
                        if (!leftIndexCandidate.isPresent()) break;
                        return new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.INNER, rightRewritten, leftIndexCandidate.get(), Rewriter.createEquiJoinClause(rightJoinSymbols, leftJoinSymbols), Optional.empty(), Optional.empty());
                    }
                    case LEFT: {
                        if (!rightIndexCandidate.isPresent()) break;
                        return new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.SOURCE_OUTER, leftRewritten, rightIndexCandidate.get(), Rewriter.createEquiJoinClause(leftJoinSymbols, rightJoinSymbols), Optional.empty(), Optional.empty());
                    }
                    case RIGHT: {
                        if (!leftIndexCandidate.isPresent()) break;
                        return new IndexJoinNode(this.idAllocator.getNextId(), IndexJoinNode.Type.SOURCE_OUTER, rightRewritten, leftIndexCandidate.get(), Rewriter.createEquiJoinClause(rightJoinSymbols, leftJoinSymbols), Optional.empty(), Optional.empty());
                    }
                    case FULL: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)node.getType()));
                    }
                }
            }
            if (leftRewritten != node.getLeft() || rightRewritten != node.getRight()) {
                return new JoinNode(node.getId(), node.getType(), leftRewritten, rightRewritten, node.getCriteria(), node.getLeftHashSymbol(), node.getRightHashSymbol());
            }
            return node;
        }

        private static List<IndexJoinNode.EquiJoinClause> createEquiJoinClause(List<Symbol> probeSymbols, List<Symbol> indexSymbols) {
            Preconditions.checkArgument((probeSymbols.size() == indexSymbols.size() ? 1 : 0) != 0);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(probeSymbols.get(i), indexSymbols.get(i)));
            }
            return builder.build();
        }
    }
}

