/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.TableCommitNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import java.util.Map;

public class BeginTableWrite
extends PlanOptimizer {
    private final Metadata metadata;

    public BeginTableWrite(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return PlanRewriter.rewriteWith(new Rewriter(session), plan);
    }

    private class Rewriter
    extends PlanRewriter<Void> {
        private final Session session;

        public Rewriter(Session session) {
            this.session = session;
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, PlanRewriter.RewriteContext<Void> context) {
            return new TableWriterNode(node.getId(), node.getSource().accept(this, context), this.createWriterTarget(node.getTarget()), node.getColumns(), node.getColumnNames(), node.getOutputSymbols(), node.getSampleWeightSymbol());
        }

        @Override
        public PlanNode visitDelete(DeleteNode node, PlanRewriter.RewriteContext<Void> context) {
            TableHandle handle = BeginTableWrite.this.metadata.beginDelete(this.session, node.getTarget().getHandle());
            return new DeleteNode(node.getId(), node.getSource().accept(this, context), new TableWriterNode.DeleteHandle(handle), node.getRowId(), node.getOutputSymbols());
        }

        @Override
        public PlanNode visitTableCommit(TableCommitNode node, PlanRewriter.RewriteContext<Void> context) {
            TableWriterNode.WriterTarget target;
            PlanNode child = node.getSource().accept(this, context);
            if (child instanceof TableWriterNode) {
                target = ((TableWriterNode)child).getTarget();
            } else if (child instanceof DeleteNode) {
                target = ((DeleteNode)child).getTarget();
            } else {
                throw new IllegalArgumentException("Invalid child for TableCommitNode: " + child.getClass().getSimpleName());
            }
            return new TableCommitNode(node.getId(), child, target, node.getOutputSymbols());
        }

        private TableWriterNode.WriterTarget createWriterTarget(TableWriterNode.WriterTarget target) {
            if (target instanceof TableWriterNode.CreateName) {
                TableWriterNode.CreateName create = (TableWriterNode.CreateName)target;
                return new TableWriterNode.CreateHandle(BeginTableWrite.this.metadata.beginCreateTable(this.session, create.getCatalog(), create.getTableMetadata()));
            }
            if (target instanceof TableWriterNode.InsertReference) {
                TableWriterNode.InsertReference insert = (TableWriterNode.InsertReference)target;
                return new TableWriterNode.InsertHandle(BeginTableWrite.this.metadata.beginInsert(this.session, insert.getHandle()));
            }
            throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
        }
    }
}

